mod character;
mod cli;
mod clock;
#[macro_use]
mod color;
mod config;
mod error;
mod position;
mod segment;
mod state;

use std::process;

use crate::{error::Error, state::State};

fn main() {
    if let Err(err) = run() {
        println!("{}Error:{} {err}", esc!("1;31"), esc!("0;1"));
        process::exit(1);
    }
}

fn run() -> Result<(), Error> {
    State::new()?.run().map_err(Error::Io)
}
