module Clay
(
-- * Rendering stylesheets to CSS.
  render
, renderWith
, putCss

, pretty
, compact

, renderSelector

-- * The @Css@ monad for collecting style rules.

, Css

, (?)
, (<?)
, (&)
, root
, pop

, (-:)

-- ** Comments
-- $comments
, commenting

-- * The selector language.

, Selector
, Refinement

-- ** Elements selectors.

, star
, element
, (**)
, (|>)
, (#)
, (|+)
, (|~)

-- ** Refining selectors.

, byId
, byClass
, pseudo
, func

-- ** Attribute based refining.

, attr
, (@=)
, (^=)
, ($=)
, (*=)
, (~=)
, (|=)

-- * Apply media queries.
-- $media

, query
, queryNot
, queryOnly

-- * Apply key-frame animation.

, keyframes
, keyframesFromTo

-- * Define font-faces.

, fontFace

-- * !important

, important

-- * Import other CSS files

, importUrl

-- * Pseudo elements and classes.

, module Clay.Pseudo

-- * HTML5 attribute and element names.

, module Clay.Attributes
, module Clay.Elements

-- * Commonly used value types.

, module Clay.Size
, module Clay.Color
, module Clay.Time

-- * Values shared between multiple properties.

, module Clay.Common

-- * Embedded style properties.

, module Clay.Background
, module Clay.Border
, module Clay.Box
, module Clay.Display
, module Clay.Dynamic
, module Clay.Flexbox
, module Clay.Font
, module Clay.FontFace
, module Clay.Geometry
, module Clay.Gradient
, module Clay.Grid
, module Clay.List
, module Clay.Text
, module Clay.Transform
, module Clay.Transition
, module Clay.Animation
, module Clay.Mask
, module Clay.Filter

-- * Writing your own properties.

, module Clay.Property
)
where

import Prelude ()

import Clay.Render
import Clay.Stylesheet
import Clay.Selector
import Clay.Property

import Clay.Pseudo hiding (default_, required, root, lang)
import Clay.Elements hiding (link, em)
import Clay.Attributes hiding
  ( content, class_, target, checked, disabled
  , value, width, height, size, translate
  , hidden, start
  )

import Clay.Background
import Clay.Border
import Clay.Box
import Clay.Color
import Clay.Time
import Clay.Comments (commenting)
import Clay.Common
import Clay.Display    hiding (table)
import Clay.Dynamic
import Clay.Flexbox    hiding (flex, nowrap, wrap)
import Clay.Font       hiding (menu, caption, small, icon)
import Clay.FontFace
import Clay.Geometry
import Clay.Gradient
import Clay.Grid
import Clay.List
import Clay.Size
import Clay.Text       hiding (pre)
import Clay.Transform
import Clay.Transition
import Clay.Animation
import Clay.Mask       hiding (clear)
import Clay.Filter     hiding (url, opacity)

-- $media
--
-- Because a large part of the names export by "Clay.Media" clash with names
-- export by other modules we don't re-export it here and recommend you to
-- import the module qualified.

-- $comments
--
-- It is occasionally useful to output comments in the generated css.
-- 'commenting' appends comments (surrounded by '@ /* @' and '@ */@') to the
-- values of the supplied 'Css' as
--
-- > key: value /* comment */;
--
-- Placing the comments before the semicolon ensures they are obviously
-- grouped with the preceding value when rendered compactly.
--
-- Note that /every/ generated line in the generated content will feature the
-- comment.
--
-- An empty comment generates '@/*  */@'.
