.\" Automatically generated from an mdoc input file.  Do not edit.
.\" Copyright (c) 2005-2022 Dieter Baron and Thomas Klausner.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above
.\"    copyright notice, this list of conditions and the following
.\"    disclaimer in the documentation and/or other materials provided
.\"    with the distribution.
.\" 3. The name of the author may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THOMAS KLAUSNER ``AS IS'' AND ANY
.\" EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR
.\" CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
.\" SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
.\" LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
.\" USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
.\" ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
.\" OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
.\" OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.TH "MKMAMEDB" "1" "January 8, 2025" "NiH" "General Commands Manual"
.nh
.if n .ad l
.SH "NAME"
\fBmkmamedb\fR
\- create database for use by ckmame
.SH "SYNOPSIS"
.HP 9n
\fBmkmamedb\fR
[\fB\-fhtuV\fR]
[\fB\-C\fR\ \fItypes\fR]
[\fB\-F\fR\ \fIformat\fR]
[\fB\-o\fR\ \fIdbfile\fR]
[\fB\-x\fR\ \fIpattern\fR]
[\fB\-\fR\fB\-all-sets\fR]
[\fB\-\fR\fB\-detector\fR\ \fIxml\-file\fR]
[\fB\-\fR\fB\-directory\-cache\fR]
[\fB\-\fR\fB\-exclude\fR\ \fIpattern\fR]
[\fB\-\fR\fB\-format\fR\ \fIformat\fR]
[\fB\-\fR\fB\-hash\-types\fR\ \fItypes\fR]
[\fB\-\fR\fB\-help\fR]
[\fB\-\fR\fB\-list\-available\-dats\fR]
[\fB\-\fR\fB\-list\-dats\fR]
[\fB\-\fR\fB\-list\-sets\fR]
[\fB\-\fR\fB\-mia\-games\fR]
[\fB\-\fR\fB\-no\-directory\-cache\fR]
[\fB\-\fR\fB\-only\-files\fR\ \fIpattern\fR]
[\fB\-\fR\fB\-output\fR\ \fIdbfile\fR]
[\fB\-\fR\fB\-prog\-description\fR\ \fIdescription\fR]
[\fB\-\fR\fB\-prog\-name\fR\ \fIname\fR]
[\fB\-\fR\fB\-prog\-version\fR\ \fIversion\fR]
[\fB\-\fR\fB\-roms\-unzipped\fR]
[\fB\-\fR\fB\-set\fR\ \fIpattern\fR]
[\fB\-\fR\fB\-skip\-files\fR\ \fIpattern\fR]
[\fB\-\fR\fB\-use\-description\-as\-name\fR]
[\fB\-\fR\fB\-use\-temp\-directory\fR]
[\fB\-\fR\fB\-version\fR]
[[\fIrominfo\-file\fR\ |\ \fIdirectory\fR\ |\ \fI-\fR]\ \fI...\fR]
.SH "DESCRIPTION"
\fBmkmamedb\fR
converts ROM set descriptions from one format to another.
.PP
If no argument is given,
\fBmkmamedb\fR
reads the
ckmamerc(5)
config file and checks if it needs to update the default database.
.PP
When a
\fIrominfo\-file\fR
is specified, it is used as input file; if the argument is
\fI-\fR,
\fBmkmamedb\fR
expects the database on standard input (stdin).
.PP
When a
\fIdirectory\fR
is specified, the files in that directory are checksummed and written
to the database.
.PP
The default output file is
\fImame.db\fR.
You can override it with the
\fB\-o\fR
option or the
\fRMAMEDB\fR
environment variable.
.PP
Supported input formats are:
.RS 6n
.PD 0
.TP 4n
\fB\(bu\fR
CMPro dat file
.TP 4n
\fB\(bu\fR
MAME XML file
.TP 4n
\fB\(bu\fR
MESS Softlist XML file
.TP 4n
\fB\(bu\fR
Romcenter dat file
.TP 4n
\fB\(bu\fR
ckmame(1)
database format
.TP 4n
\fB\(bu\fR
directory of zip archives
.TP 4n
\fB\(bu\fR
directory with subdirectories (with
\fB\-u\fR);
each sub-directory is taken as a game
.RE
Supported output formats are:
.RS 6n
.TP 4n
\fB\(bu\fR
ckmame(1)
database format
.TP 4n
\fB\(bu\fR
CMPro dat file
.TP 4n
\fB\(bu\fR
Logiqx XML dat file
.TP 4n
\fB\(bu\fR
mtree(8)
file
.RE
.PD
.PP
The CMPro file format is described at
\fIhttp://www.logiqx.com/FAQs/CMPro.shtml\fR,
the DTD for MAME xml can be found in
\fIPREFIX/share/doc/ckmame/\fR.
.SS "OPTIONS"
\fBmkmamedb\fR
supports the following options:
.TP 32n
\fB\-\fR\fB\-all-sets\fR
Do the action for all configured sets.
.TP 32n
\fB\-C\fR \fItypes\fR, \fB\-\fR\fB\-hash\-types\fR \fItypes\fR
A comma separated list of hash types to compute when creating a ROM
set description from a directory of zip archives.
Supported hash types are: crc, md5, sha1.
Default are all.
.TP 32n
\fB\-\fR\fB\-detector\fR \fIxml\-file\fR
Use CMPro XML header skip detector description from
\fIfile\fR.
This overrides any detectors given in the file itself.
\fBmkmamedb\fR
looks for the detector in the input file (if it is a zip file) or
the directory of the input file.
.TP 32n
\fB\-\fR\fB\-directory\-cache\fR
When
\fBmkmamedb\fR
is used to create a database from an input directory, it will by
default write a
\fI.ckmame.db\fR
database file to it, caching the directory contents' hashes in it so
that consecutive re-runs are faster.
When
\fBmkmamedb\fR
finds such a database, it only computes the hashes for the files that
have changed since the last run.
.TP 32n
\fB\-F\fR \fIformat\fR, \fB\-\fR\fB\-format\fR \fIformat\fR
Specify output format.
Supported formats are
\fBcm\fR
(clrmamepro dat file),
\fBdat\fR
(XML datfile),
\fBdb\fR
(ckmame(1)
database), and
\fBmtree\fR
(mtree(8)
file).
The default is cm.
.TP 32n
\fB\-f\fR, \fB\-\fR\fB\-force\fR
Create database even if it is not out-of-date.
.TP 32n
\fB\-h\fR, \fB\-\fR\fB\-help\fR
Display a short help message.
.TP 32n
\fB\-\fR\fB\-no\-directory\-cache\fR
Turn off
\fB\-\fR\fB\-directory\-cache\fR.
.TP 32n
\fB\-o\fR \fIdbfile\fR, \fB\-\fR\fB\-output\fR \fIdbfile\fR
Write to database
\fIdbfile\fR
instead of the default
\(lq\fImame.db\fR\(rq.
.TP 32n
\fB\-\fR\fB\-list\-available\-dats\fR
List the names of all dats found in the configured dat directories.
.TP 32n
\fB\-\fR\fB\-list\-dats\fR
List dats configured for the selected set.
.TP 32n
\fB\-\fR\fB\-list\-sets\fR
List all configured sets.
.TP 32n
\fB\-\fR\fB\-mia\-games\fR \fIfile\fR
Mark ROMs from games listed in
\fIfile\fR
as mia, except if their name matches
\(lqdelete-unknown-pattern\(rq.
.TP 32n
\fB\-\fR\fB\-only\-files\fR \fIpattern\fR
When reading files from the file system as input,
only accept files matching the shell glob
\fIpattern\fR.
.TP 32n
\fB\-\fR\fB\-prog\-description\fR \fIdescription\fR
Set description for the program the ROM info is from.
.TP 32n
\fB\-\fR\fB\-prog\-name\fR \fIname\fR
Set name of the program the ROM info is from.
.TP 32n
\fB\-\fR\fB\-prog\-version\fR \fIversion\fR
Set version of the program the ROM info is from.
.TP 32n
\fB\-\fR\fB\-set\fR \fIpattern\fR
Run
\fBmkmamedb\fR
for all sets matching
\fIpattern\fR.
.TP 32n
\fB\-\fR\fB\-skip\-files\fR \fIpattern\fR
When reading files from the file system as input,
skip files matching the shell glob
.TP 32n
\fB\-t\fR, \fB\-\fR\fB\-use\-temp\-directory\fR
Create the output in a temporary directory and move it to the real
output when finished.
This might speed up the creation e.g. of
\fImame.db\fR
when your current working directory is on a slow file system.
.TP 32n
\fB\-u\fR, \fB\-\fR\fB\-roms\-unzipped\fR
ROMs are files on the disk.
Each game is represented by a directory instead of a ZIP archive.
Only relevant when creating a database based on file system contents.
.TP 32n
\fB\-\fR\fB\-use\-description\-as\-name\fR
Use the value of the
\(lqdescription\(rq
field instead of the
\(lqname\(rq
field as game name.
.TP 32n
\fB\-V\fR, \fB\-\fR\fB\-version\fR
Display program name and version number.
.TP 32n
\fB\-x\fR \fIpat\fR, \fB\-\fR\fB\-exclude\fR \fIpat\fR
Exclude games with names matching
\fIpat\fR
from the created database.
.SH "ENVIRONMENT"
.TP 12n
\fRMAMEDB\fR
Location for the database file.
Can be overridden with the
\fB\-o\fR
option.
Defaults to
\(lq\fImame.db\fR\(rq.
.SH "FILES"
.TP 17n
.mkmamedb.db
Directory cache file for
\fB\-\fR\fB\-directory-cache\fR
.SH "EXAMPLES"
Get an input file for
mkmamedb(1)
from MAME and convert it to the internal database format:
.nf
.sp
.RS 0n
# mame \-listxml | mkmamedb -
.RE
.fi
.SH "SEE ALSO"
ckmame(1),
dumpgame(1),
ckmamerc(5)
.SH "AUTHORS"
\fBmkmamedb\fR
was written by
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fIwiz@gatalith.at\fR>.
