use super::Iconize;
use bytesize::ByteSize;
use std::fmt;

pub struct MemoryFormatter {
    used: u64,
    total: u64,
    percentage: f64,
}

impl MemoryFormatter {
    pub fn new() -> Self {
        Self {
            used: 0,
            total: 0,
            percentage: 0f64,
        }
    }

    pub fn set_used(&mut self, amount: u64) {
        self.used = amount;
    }

    pub fn set_total(&mut self, amount: u64) {
        self.total = amount;
    }

    pub fn set_percentage(&mut self) {
        self.percentage = self.used as f64 / self.total as f64 * 100f64;
    }

    pub fn get_used(&self) -> ByteSize {
        ByteSize::kb(self.used)
    }

    pub fn get_total(&self) -> ByteSize {
        ByteSize::kb(self.total)
    }

    pub fn get_percentage(&self) -> String {
        format!("{:.1}%", self.percentage)
    }
}

impl Iconize for MemoryFormatter {
    fn set_icon(&self) -> &str {
        "media-floppy-symbolic"
    }
}

impl fmt::Display for MemoryFormatter {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        write!(
            f,
            "{} / {} ({})",
            self.get_used(),
            self.get_total(),
            self.get_percentage()
        )
    }
}
