use std::fmt;

#[derive(Clone, Copy, Debug, PartialEq)]
pub enum Meridiem {
    Ante,
    Post,
}

impl fmt::Display for Meridiem {
    fn fmt(&self, f: &mut fmt::Formatter<'_>) -> fmt::Result {
        match *self {
            Meridiem::Ante => write!(f, "AM"),
            Meridiem::Post => write!(f, "PM"),
        }
    }
}
