use std::fmt;
use time::Weekday;

#[derive(Clone, Copy, Debug, PartialEq)]
pub enum Day {
    Monday,
    Tuesday,
    Wednesday,
    Thursday,
    Friday,
    Saturday,
    Sunday,
}

impl Day {
    pub fn short(self) -> impl fmt::Display {
        struct Short(Day);
        impl fmt::Display for Short {
            fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
                match self.0 {
                    Day::Monday => write!(f, "Mon"),
                    Day::Tuesday => write!(f, "Tue"),
                    Day::Wednesday => write!(f, "Wed"),
                    Day::Thursday => write!(f, "Thu"),
                    Day::Friday => write!(f, "Fri"),
                    Day::Saturday => write!(f, "Sat"),
                    Day::Sunday => write!(f, "Sun"),
                }
            }
        }
        Short(self)
    }

    pub fn long(self) -> impl fmt::Display {
        struct Long(Day);
        impl fmt::Display for Long {
            fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
                match self.0 {
                    Day::Monday => write!(f, "Monday"),
                    Day::Tuesday => write!(f, "Tuesday"),
                    Day::Wednesday => write!(f, "Wednesday"),
                    Day::Thursday => write!(f, "Thursday"),
                    Day::Friday => write!(f, "Friday"),
                    Day::Saturday => write!(f, "Saturday"),
                    Day::Sunday => write!(f, "Sunday"),
                }
            }
        }
        Long(self)
    }
}

impl From<Weekday> for Day {
    fn from(weekday: Weekday) -> Day {
        match weekday {
            Weekday::Monday => Day::Monday,
            Weekday::Tuesday => Day::Tuesday,
            Weekday::Wednesday => Day::Wednesday,
            Weekday::Thursday => Day::Thursday,
            Weekday::Friday => Day::Friday,
            Weekday::Saturday => Day::Saturday,
            Weekday::Sunday => Day::Sunday,
        }
    }
}
