# citron's changelog

## v0.15.0

battery: add '%S' specifier for displaying battery status through a symbol

- This specifier is inspired by Emacs' battery-mode-line-format '%b' specifier.

- Other minor changes:

  + The conditions which decide upon which battery icon to display depending on
    the battery percentage have been decremented by 1.

    - This means that if your battery's percentage is 20%, you'll be shown a
      battery-level-20-discharging-symbolic icon instead of
      battery-level-10-discharging-symbolic icon.

  + Bump dependencies to their latest versions.

## v0.14.2

Moved from chrono to time, as chrono is vulnerable with a [potential
segfault](https://rustsec.org/advisories/RUSTSEC-2020-0159) in its invocations
of [localtime_r](https://linux.die.net/man/3/localtime_r).

For more information, see this
[thread](https://github.com/chronotope/chrono/issues/602).

## v0.14.1

- Bump to libmacchina v6.1.0, a bug fix release addressing:
   - https://github.com/Macchina-CLI/libmacchina/issues/115 (Network)
   - https://todo.sr.ht/~grtcdr/citron/1 (Battery)

## v0.14.0

- You'll now see your battery's percentage even if its state is unknown.
- Under the hood changes that mostly address the flow of data within citron.
- Respect IO streams, error messages are now written to stderr.

## v0.13.0

This release addresses citron's documentation.

- Removed example configuration file, I don't want to maintain the config as
  the source evolves. citron's manpage fully documents its features and
  configuration options.

- Rewrote the manpage in scd (scdoc).
  The "doc" directory looks like this now:

  doc
  ├──citron.1
  └──citron.1.scd

- A change in marketing: citron's description will now longer tell you to
  "ditch your status bar", instead it tells you what it is, "system data via
  on-demand notifications".

## v0.12.0

- The network notification can be fully configured through symbols now.
- Dropped owo-colors dependency, colors are no more.
- Fixed duplicate about message of subcommands when consulting --help.
- Refactor various parts ot the codebase.

## v0.11.0

- Configuration: Added new date symbols.
- Configuration: The battery group, or whatever YAML calls it, now has a format option, similar to
  the date group. Its symbols are fully documented in the manpage, under the BATTERY SYMBOLS section.
- Network: When disconnected, the network notification will show a
  "network-wireless-disconnected-symbolic" icon. In other terms, the network notification is
  contextually-aware.
- Miscellaneous: Some refactoring work has gone into our formatters (which are responsible for the
  final format of the notification's body).
- Miscellaneous: Added a CHANGELOG.md that keeps track of the history of changes introduced by
  every version.

## v0.10.1

Fix a build warning.

## v0.10.0
- Add a new month symbol (%M) which shows a long version of the current
  month, e.g. "January".
- Fix a bug that made it so the month symbol (%m) showed the month's number
  rather than its textual representation.

## v0.9.0

citron can only be configured through a config file now, as its
command-line interface has been stripped down to subcommands a few
flags.

An example configuration file can be found at:
https://git.sr.ht/~grtcdr/citron/tree/main/item/config.yml

## v0.8.0

This version makes improvements to citron's CLI interface, i.e. the
flags that you use to interact with it.

All of its functionalities have become subcommands.

- Previously: `citron --date`
- Now: `citron date`

This means options are now specific to their respective subcommand, e.g.
`--railway` will only show up when consulting the help section of the
`date` subcommand, and it will only work for it too.

One more thing, the usage of icons no longer requires calling two
different flags, one is enough, and that one has now been renamed
to just `-I`, it does not currently have a long name.

- Previously: `citron -nIT Papirus`
- Now: `citron n -I Papirus`

## v0.7.0

This is not a feature release, nor is it a bugfix release, citron just
relocated to sr.ht, and thus its manifest (Cargo.toml) had to be updated.

## v0.6.4

Squash a bug that stopped network statistics from showing up on NetBSD

## v0.6.3

Bump libmacchina to v5.0.2: This addresses a bug (incorrect filter usage) that
occurs during the fetching of battery statistics on Linux.

## v0.6.2

Bump libmacchina to v5.0.1: Small fix in the backend that adds back an allow
`dead_code` attribute in a specific module to avoid getting a bunch of warnings
at build-time.

## v0.6.1

Bump libmacchina to v5.0: citron is not affected by libmacchina's new breaking
changes, but the most notable change in this new version of libmacchina is the
introduction of the "hash" feature, which citron does not enable, this drops a
lot of dependencies that we don't need.

## v0.6.0

Add support for icons

## v0.5.0

Add an option (-R) to use railway time.

## v0.4.1

Add timezone auto-detection.

## v0.4.0

Refactoring work.

## v0.3.0

Add an option (-D) to view debug information.

## v0.2.0

To new beginnings!
