/*
 * CHEST, chess analyst.  For Copyright notice read file "COPYRIGHT".
 *
 * $Source: /home/heiner/ca/chest/RCS/asw.c,v $
 * $Id: asw.c,v 3.5 1999/07/20 20:59:41 heiner Exp $
 *
 *	answer switch
 */

#include "types.h"
#include "board.h"
#include "answer.h"
#include "asw.h"


/*
 * Sort a list of (all) legal moves for the purpose of defending
 * against an attack (already executed) of the specified depth.
 * Here decide for and call the appropriate specialized procedure.
 * Return the approximate cost as needed by "analyse()".
 */

#define MIN_SORT_DEPTH	2		/* else sorting is too expensive */

typedef int (*	FuncPtr)(int, Xconst Board*, Movelist*);
					/* pointer to answer function */

static const FuncPtr	answer_func[] ={	/* answer function by depth */
	/* 0 */	0,
	/* 1 */	0,
	/* 2 */	sort_2_weighted,
};

static const FuncPtr	default_func = sort_weighted;

    Eximpl int
sort_answer(
    int			depth,
    Xconst Board*	bp,
    Movelist*		lp)
{
    register FuncPtr	fp;

    if( depth < MIN_SORT_DEPTH ) {
	return(0);		/* nothing done, no cost */
    }
#if 1
    if( lp->l_free < &(lp->l_m[2]) ) {
	return 0;		/* not at least 2 moves => leave alone */
    }
#endif
    if( depth >= NELEMS(answer_func) ) {
	fp = default_func;
    }else {
	fp = answer_func[depth];
	if( fp == (FuncPtr)0 ) {
	    fp = default_func;
	}
    }
    return (*fp)(depth, bp, lp);
}
