/*** DTB_USER_CODE_START vvv Add file header below vvv ***/
/*
 * CDE - Common Desktop Environment
 *
 * Copyright (c) 1993-2012, The Open Group. All rights reserved.
 *
 * These libraries and programs are free software; you can
 * redistribute them and/or modify them under the terms of the GNU
 * Lesser General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * These libraries and programs are distributed in the hope that
 * they will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with these libraries and programs; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
 */
/*** DTB_USER_CODE_END   ^^^ Add file header above ^^^ ***/

/*
 * File: message_ed_stubs.c
 * Contains: Module callbacks and connection functions
 *
 * This file was generated by dtcodegen, from module message_ed
 *
 * Any text may be added between the DTB_USER_CODE_START and
 * DTB_USER_CODE_END comments (even non-C code). Descriptive comments
 * are provided only as an aid.
 *
 *  ** EDIT ONLY WITHIN SECTIONS MARKED WITH DTB_USER_CODE COMMENTS.  **
 *  ** ALL OTHER MODIFICATIONS WILL BE OVERWRITTEN. DO NOT MODIFY OR  **
 *  ** DELETE THE GENERATED COMMENTS!                                 **
 */

#include <stdint.h>
#include <stdio.h>
#include <Xm/Xm.h>
#include "dtb_utils.h"
#include "dtbuilder.h"
#include "message_ed_ui.h"


/**************************************************************************
 *** DTB_USER_CODE_START
 ***
 *** All necessary header files have been included.
 ***
 *** Add include files, types, macros, externs, and user functions here.
 ***/

/* REMIND: aim - temporarily Added to get around compiler error */
#undef _POSIX_SOURCE

#include <Xm/PushB.h>
#include <Xm/List.h>
#include <Xm/RowColumn.h>
#include "dtbuilder.h"
#include "message_ed_ui.h"
#include <ab_private/ab.h>
#include <ab_private/abobj_list.h>
#include <ab_private/abobj_set.h>
#include <ab_private/prop.h>
#include <ab_private/message.h>
#include <ab_private/ui_util.h>
#include <ab_private/obj_notify.h>
#include <ab_private/proj.h>
#include <ab_private/trav.h>
#include <ab_private/conn.h>
#include <ab_private/help.h>

typedef enum
{
    MSG_ED_RETRY_STR = 0,
    MSG_ED_OK_STR,
    MSG_ED_CLOSE_STR,
    MSG_ED_STOP_STR,
    MSG_ED_YES_STR,
    MSG_ED_NO_STR,
    MSG_ED_CONT_STR,
    MSG_ED_NO_MODULES_STR,
    MSG_ED_NUM_STRS
} MSG_ED_STR_TYPE;

static char	*msgEd_strings[MSG_ED_NUM_STRS];

/*
 * Message Editor Settings
 */
typedef struct  MESSAGE_EDITOR_SETTINGS
{
    Widget                      prop_sheet;
    PropFieldSettingRec         name;
    PropFieldSettingRec         title;
    PropOptionsSettingRec       msg_type;
    Widget			msg_textp_label;
    PropFieldSettingRec         msg;
    PropCheckboxSettingRec      action1_button;
    PropFieldSettingRec         action1_label;
    PropCheckboxSettingRec      action2_button;
    PropFieldSettingRec        	action2_label;
    PropCheckboxSettingRec      action3_button;
    PropFieldSettingRec        	action3_label;
    PropCheckboxSettingRec      cancel_button;
    PropCheckboxSettingRec      help_button;
    PropOptionsSettingRec       default_btn;
    ABObj			current_obj;
} MsgEditorSettingsRec, *MsgEditorSettings;

typedef enum {
    MOD_UNDEF = 0,
    MOD_ADD,
    MOD_DELETE,
    MOD_REPLACE,
    MOD_NUM_ITEMS
} MOD_OP;

/*
 * Declarations of global widgets used by callbacks.
 */

MsgEditorSettingsRec 	msg_editor_settings_rec;
ABObj			MessageModule	= (ABObj) NULL;
static Widget   	MsgObjList	= (Widget) NULL;
static Widget   	MsgModOpmenu	= (Widget) NULL;
static Widget   	NoModulesItem	= (Widget) NULL;

/*
 * End declarations of global widgets
 */

/****************************************************************
**                                                             **
**       Private Function Declarations                         **
**                                                             **
*****************************************************************/
static Widget   msg_editor_init(
                    DtbMessageEdDialogInfo      msg_cgen,
                    Widget              	parent
                );
static int      msg_editor_load(
                    ABObj   project
                );
static int 	msg_editor_clear(
		);

/*
 * General routines
 */
static void     turnoff_changebars(
                );
static void 	setup_button_fields(
		    AB_MESSAGE_TYPE mtype
		);
static void 	setup_btn_lbl_field(
		    int         button,
		    BOOL        value
		);
static void 	set_msg_textp_label(
		    AB_MESSAGE_TYPE mtype
		);
static void 	msgEdP_init();

static int 	msgEdP_msgpane_init(
		   DtbMessageEdDialogInfo      cgen
		);
static DTB_MODAL_ANSWER msgEdP_do_auto_apply(
		    Widget      list,
		    ABObj       old_obj,
		    ABObj       new_obj
		);
static BOOL 	apply_changes(
		    ABObj       obj
		);
static void 	objlist_load(
		   Widget      list
		);
static BOOL 	objlist_test_func(
		    ABObj test_obj
		);
static int 	build_module_opmenu(
		   DtbMessageEdDialogInfo      cgen
		);

static BOOL 	verify_name(); 
static BOOL 	verify_default_btn();
static BOOL 	verify_label();
static BOOL 	verify_buttons();

static int 	update_mod_opmenu(
		    MOD_OP      op,
		    STRING      item_str,
		    STRING      new_item_str,
		    Widget      *RetItem,
		    int         *ModItemCount
		);

static void	msgEdP_strings_init(
		);

/*               
 * Callbacks
 */
static void 	msgEdP_prevent_closeCB(
		    Widget      widget,
		    XtPointer   client_data,
		    XtPointer   call_data
		);
static void     typeCB(
                    Widget   widget,
                    XtPointer clientdata,
                    XtPointer calldata
                );
static void     buttonCB(
                    Widget   widget,
                    XtPointer clientdata,
                    XmToggleButtonCallbackStruct *state
                );
static int 	obj_updateOCB(
		    ObjEvUpdateInfo     info
		);
static int 	obj_destroyedOCB(
		    ObjEvDestroyInfo    info
		);
static int 	obj_renamedOCB(
		    ObjEvAttChangeInfo    info
		);
static void 	objlist_selectCB(
		    Widget      widget,
		    XtPointer   client_data,
		    XmListCallbackStruct *listdata
		);
static void     change_msg_moduleCB(
                    Widget   widget,
                    XtPointer clientdata,
                    XtPointer calldata
                );

 
/*****************************************************************
** 								**
**       Function Definitions					**
** 								**
******************************************************************/

void
msgEd_show_dialog(void)
{
    int		numMods = 0;
    ABObj	current_module = proj_get_cur_module();

    /* If there is no Message Editor, create it */
    if (AB_msgEd_dialog == (Widget)NULL)
    {
	/* Create and manage the Message Editor */
        AB_msgEd_dialog = msg_editor_init(&dtb_message_ed_dialog, 
				dtb_get_toplevel_widget());

	/* Set up handles for important widgets */
	MsgObjList 	= dtb_message_ed_dialog.msg_list;
	MsgModOpmenu 	= dtb_message_ed_dialog.module_opmenu;
	NoModulesItem 	= 
	    dtb_message_ed_dialog.module_opmenu_items.No_Modules_item;

	/* Initially set the right-side of the Message
	 * Editor inactive.  It becomes active when a
	 * message object is loaded (selected).
	 */
	ui_set_active(dtb_message_ed_dialog.ctrl_panel2, FALSE);
	ui_set_active(dtb_message_ed_dialog.ok_button, False);
	ui_set_active(dtb_message_ed_dialog.apply_button, False);
	ui_set_active(dtb_message_ed_dialog.reset_button, False); 

	/* Add Update, Rename, and Destroy object callbacks */
	msgEdP_init();

	/* Set up the Message list behavior and initialize the 
	 * Module OptionMenu. If there are no shown modules,
	 * then make the left-hand side of the Message Editor
	 * inactive.
	 */
	numMods = msgEdP_msgpane_init(&dtb_message_ed_dialog);
	if (numMods == 0)
	{
	    ui_set_active(dtb_message_ed_dialog.ctrl_panel, FALSE);
	}

	/* Load in the initial messages list */
	objlist_load(dtb_message_ed_dialog.msg_list); 

        XtVaSetValues(dtb_message_ed_dialog.dialog_form,
                XmNresizePolicy,        XmRESIZE_ANY,
                XmNallowResize,         True,
                NULL);
        /*
         * Setup dialog to participate in dtbuilder window protocol
         */
        ab_register_window(AB_msgEd_dialog, AB_WIN_DIALOG, 
		WindowHidden, AB_toplevel, AB_WPOS_TILE_HORIZONTAL,
		msgEdP_prevent_closeCB, NULL);
    }

    if (AB_msgEd_dialog != NULL)
    {

	/* If the message object that was last selected is in
	 * the project's current module, then show the Message
	 * Editor as it was last dislayed (i.e. with the same
	 * message object selected and loaded).  If the message 
	 * object that was last selected is not in the project's
	 * current module, or if no object was selected, then show 
	 * the Message Editor with the Module optionmenu showing 
	 * the project's current module and none of the message 
	 * objects selected.  There should never be a case where
	 * current_module is NULL and MessageModule is not NULL.
	 * If there are no modules in the project, then both 
	 * MessageModule and current_module will be NULL, so this 
	 * won't get executed.
	 */
	if (MessageModule != current_module)
	{
	    msg_editor_clear();
	    ui_optionmenu_change_label(MsgModOpmenu,
			obj_get_name(current_module));
	    XtUnmanageChild(NoModulesItem);
	    MessageModule = current_module;
	}
     	ab_show_window(AB_msgEd_dialog);
    }
}

/*
 * Initialize Code Generator Props:
 *      Add callbacks for object rename & destroy
 */
static void
msgEdP_init(void)
{
    /*
     * Initialize static strings used in message editor
     */
    msgEdP_strings_init();

    obj_add_rename_callback(obj_renamedOCB, "msgEdP_init");
    obj_add_update_callback(obj_updateOCB, "msgEdP_init");
    obj_add_destroy_callback(obj_destroyedOCB, "msgEdP_init");
}


static Widget
msg_editor_init(
    DtbMessageEdDialogInfo	msg_cgen,
    Widget			parent
)                
{
    MsgEditorSettingsRec	*mes = &msg_editor_settings_rec;
    Widget                      item[6];
    int                         item_val[6];
    int                         i, n;
 
    /*
     * Create Dialog widgets...
     */
    dtbMessageEdDialogInfo_clear(msg_cgen);
       
    if (dtb_message_ed_dialog_initialize(msg_cgen, parent) == 0)
    {
        /*
         * Hook widgets up to Message Editor
         */
        mes->prop_sheet = msg_cgen->ctrl_panel2;
        mes->current_obj = NULL;

        /* Name */
        prop_field_init(&(mes->name), msg_cgen->name_field_label,
                msg_cgen->name_field, msg_cgen->name_cb);

        /* Title */
        prop_field_init(&(mes->title), msg_cgen->title_field_label,
                msg_cgen->title_field, msg_cgen->title_cb);
 
        /* Message Type */
        n = 0;
        item[n] = msg_cgen->type_opmenu_items.bitmaps_xm_error_xbm_item;
        item_val[n] = AB_MSG_ERROR; n++;
        item[n] = msg_cgen->type_opmenu_items.bitmaps_xm_information_xbm_item;
        item_val[n] = AB_MSG_INFORMATION; n++;
        item[n] = msg_cgen->type_opmenu_items.bitmaps_xm_question_xbm_item;
        item_val[n] = AB_MSG_QUESTION; n++;
        item[n] = msg_cgen->type_opmenu_items.bitmaps_xm_warning_xbm_item;
        item_val[n] = AB_MSG_WARNING; n++;
        item[n] = msg_cgen->type_opmenu_items.bitmaps_xm_working_xbm_item;
        item_val[n] = AB_MSG_WORKING; n++;
        prop_options_init(&(mes->msg_type), msg_cgen->type_opmenu_label,
                msg_cgen->type_opmenu, msg_cgen->type_opmenu_menu,
                n, item, (XtPointer*)item_val, msg_cgen->msg_cb);
	/*
	 * typeCB sets the button checkboxes/label fields to the
 	 * correct default values, when a message type is chosen.
	 */
        for(i=0; i < n; i++)
            XtAddCallback(item[i], XmNactivateCallback,
                        (XtCallbackProc)typeCB, (XtPointer)NULL);

	/* Message textpane label */
	mes->msg_textp_label = msg_cgen->msg_textp_label;

        /* Message */
        prop_field_init(&(mes->msg), msg_cgen->msg_textp_label, 
		msg_cgen->msg_textpane, msg_cgen->msg_cb);

        /* Action1 (OK) Button */
        n = 0;
        item[n] = msg_cgen->action1_cbox_items.nolabel_item;
        item_val[n] = ACTION1_ITEM_KEY; n++;
        prop_checkbox_init(&(mes->action1_button), msg_cgen->action1_cbox_label,
                msg_cgen->action1_cbox, n, item, item_val, msg_cgen->action1_cb);

	/* buttonCB makes the corresponding label textfield 
	 * active/inactive and resets the Action button label
	 * to NULL if the user specifies no button.
	 */
        XtAddCallback(item[0], XmNvalueChangedCallback,
                        (XtCallbackProc)buttonCB, (XtPointer)NULL);
 
        /* Action1 (OK) Button Label */
	prop_field_init(&(mes->action1_label), NULL,
			msg_cgen->action1_field, msg_cgen->action1_cb);
 
        /* Action2 (Extra) Button */  
        n = 0;
        item[n] = msg_cgen->action2_cbox_items.nolabel_item;
        item_val[n] = ACTION2_ITEM_KEY; n++;
        prop_checkbox_init(&(mes->action2_button), msg_cgen->action2_cbox_label,
	    msg_cgen->action2_cbox, n, item, item_val, msg_cgen->action2_cb);

	/* buttonCB makes the corresponding label textfield 
	 * active/inactive and resets the Action button label
	 * to NULL if the user specifies no button.
	 */
	XtAddCallback(item[0], XmNvalueChangedCallback,
                        (XtCallbackProc)buttonCB, (XtPointer)NULL);
 
        /* Action2 (Extra) Button Label */
        prop_field_init(&(mes->action2_label), NULL,
			msg_cgen->action2_field, msg_cgen->action2_cb);

        /* Action3 (Extra) Button */
        n = 0;
        item[n] = msg_cgen->action3_cbox_items.nolabel_item;
        item_val[n] = ACTION3_ITEM_KEY; n++;
        prop_checkbox_init(&(mes->action3_button), msg_cgen->action3_cbox_label,
            msg_cgen->action3_cbox, n, item, item_val, msg_cgen->action3_cb);

	/* buttonCB makes the corresponding label textfield 
	 * active/inactive and resets the Action button label
	 * to NULL if the user specifies no button.
	 */
	XtAddCallback(item[0], XmNvalueChangedCallback,
                        (XtCallbackProc)buttonCB, (XtPointer)NULL);
 
        /* Action3 (Extra) Button Label */
        prop_field_init(&(mes->action3_label), NULL,
                        msg_cgen->action3_field, msg_cgen->action3_cb);

        /* Cancel Button */
        n = 0;
        item[n] = msg_cgen->cancel_cbox_items.nolabel_item;
        item_val[n] = CANCEL_ITEM_KEY; n++;
        prop_checkbox_init(&(mes->cancel_button), msg_cgen->cancel_cbox_label,
                msg_cgen->cancel_cbox, n, item, item_val, msg_cgen->cancel_cb);

        /* Help Button */
        n = 0;
        item[n] = msg_cgen->help_cbox_items.nolabel_item;
        item_val[n] = HELP_ITEM_KEY; n++;
        prop_checkbox_init(&(mes->help_button), msg_cgen->help_cbox_label,
                msg_cgen->help_cbox, n, item, item_val, msg_cgen->help_cb);
 
        /* Default Button */
        n = 0;
        item[n] = msg_cgen->default_btn_opmenu_items.Action1_item;
        item_val[n] = AB_DEFAULT_BTN_ACTION1; n++;

        item[n] = msg_cgen->default_btn_opmenu_items.Action2_item;
        item_val[n] = AB_DEFAULT_BTN_ACTION2; n++;

        item[n] = msg_cgen->default_btn_opmenu_items.Action3_item;
        item_val[n] = AB_DEFAULT_BTN_ACTION3; n++;

        item[n] = msg_cgen->default_btn_opmenu_items.Cancel_item;
        item_val[n] = AB_DEFAULT_BTN_CANCEL; n++;

        item[n] = msg_cgen->default_btn_opmenu_items.None_item;
        item_val[n] = AB_DEFAULT_BTN_NONE; n++;

        prop_options_init(&(mes->default_btn), 
			msg_cgen->default_btn_opmenu_label,
                	msg_cgen->default_btn_opmenu, 
			msg_cgen->default_btn_opmenu_menu,
                	n, item, (XtPointer*)item_val, msg_cgen->default_btn_cb);
	/* Initially set the default button to be 
	 * Action2 (Error Message). 
	 */
	prop_options_set_value(&(mes->default_btn), (XtPointer)AB_DEFAULT_BTN_ACTION2, False);

        return (dtb_message_ed_dialog.dialog_shellform);
    }
    else
    {
        util_dprintf(3, "msg_editor_init: could not initialize Message Editor\n");
        return NULL;
    }
}

static int
msg_editor_clear(void)
{
    MsgEditorSettingsRec       *mes = &msg_editor_settings_rec;
    int				sel_pos = 0;

    if (mes->current_obj == NULL)
        return OK;

    /* Clear Name */
    prop_field_set_value(&(mes->name), "", False);

    /* Clear Title */
    prop_field_set_value(&(mes->title), "", False);

    /* Clear Message Type */
    prop_options_set_value(&(mes->msg_type), (XtPointer)AB_MSG_ERROR, False);

    /* Initialize the Message textpane label */
    set_msg_textp_label(AB_MSG_ERROR);

    /* Clear Message */
    prop_field_set_value(&(mes->msg), "", False);
 
    /* Clear Action1 Button */
    prop_checkbox_set_value(&(mes->action1_button), ACTION1_ITEM_KEY, 
				False, False);
 
    /* Clear Action1 (OK) Label */
    prop_field_set_value(&(mes->action1_label), "", False);

    /* Clear Action2 Button */
    prop_checkbox_set_value(&(mes->action2_button), ACTION2_ITEM_KEY, 
				True, False);
 
    /* Clear Action2 Label */
    prop_field_set_value(&(mes->action2_label), msgEd_strings[MSG_ED_RETRY_STR], False);

    /* Clear Action3 Button */
    prop_checkbox_set_value(&(mes->action3_button), ACTION3_ITEM_KEY,
                                False, False);
 
    /* Clear Action3 Label */
    prop_field_set_value(&(mes->action3_label), "", False);
 
    /* Clear Cancel Button */
    prop_checkbox_set_value(&(mes->cancel_button), CANCEL_ITEM_KEY,
                True, False);
 
    /* Clear Help Button */
    prop_checkbox_set_value(&(mes->help_button), HELP_ITEM_KEY, True, False);
 
    /* Clear Default Button */
    prop_options_set_value(&(mes->default_btn), (XtPointer)ACTION2_ITEM_KEY, False);

    mes->current_obj = NULL;
 
    /* Check if a message object is selected in the list.
     * If so, deselect it, since we're clearing out all
     * the fields.
     */
    sel_pos = ui_list_get_selected_pos(MsgObjList);
    if (sel_pos > 0)
    {
	XmListDeselectPos(MsgObjList, sel_pos);
    }

    ui_set_active(dtb_message_ed_dialog.ctrl_panel2, FALSE);
    ui_set_active(dtb_message_ed_dialog.ok_button, False);
    ui_set_active(dtb_message_ed_dialog.apply_button, False);
    ui_set_active(dtb_message_ed_dialog.reset_button, False);

    turnoff_changebars();
 
    return OK;
}

static int
msg_editor_load(
    ABObj    obj
)
{
    STRING                      name, msg;
    AB_MESSAGE_TYPE         	mtype = AB_MSG_UNDEF;
    AB_DEFAULT_BUTTON		button = AB_DEFAULT_BTN_UNDEF;
    MsgEditorSettingsRec    	*mes = &msg_editor_settings_rec;

    if (obj == NULL)
    {
        if (mes->current_obj != NULL)
            obj = mes->current_obj;
        else
	    return ERROR;
    }
    else if (!obj_is_message(obj))
    {
        return ERROR;
    }
    else
    {
        mes->current_obj = obj;
    }
 
    /* Load Name */
    prop_field_set_value(&(mes->name), obj_get_name(obj), False);

    /* Load Title */                                         
    prop_field_set_value(&(mes->title), obj_get_label(obj), False);
 
    /* Load Message Type */
    mtype = obj_get_msg_type(obj);
    prop_options_set_value(&(mes->msg_type), (XtPointer)mtype, False);

    /* This initially sets the appropriate button checkboxes and
     * label fields active or inactive, depending on the message 
     * type.
     */
    setup_button_fields(mtype);

    /* Set the Message textpane label to the correct string */
    set_msg_textp_label(mtype);
 
    /* Load Message */
    msg = obj_get_msg_string(obj);
    if (!util_strempty(msg))
        prop_field_set_value(&(mes->msg), msg, False);
    else
        prop_field_set_value(&(mes->msg), "", False);
 
    /* Load Action1 (OK) Button value. If the label is not 
     * NULL or the empty string, then check the Action1
     * checkbox. 
     */
    prop_checkbox_set_value(&(mes->action1_button), ACTION1_ITEM_KEY,
        		obj_has_action1_button(obj), False);

    /* Set the sensitivity of the label field according to
     * the state of its corresponding checkbox.
     */ 
    setup_btn_lbl_field(ACTION1_ITEM_KEY, obj_has_action1_button(obj));
 
    /* Load Action1 (OK) Label */
    prop_field_set_value(&(mes->action1_label),
                        obj_get_action1_label(obj), False);

    /* Load Action2 (Extra) Button value. If the label is not
     * NULL or the empty string, then check the Action2   
     * checkbox. 
     */  
    prop_checkbox_set_value(&(mes->action2_button), ACTION2_ITEM_KEY,
        		obj_has_action2_button(obj), False);

    /* Set the sensitivity of the label field according to
     * the state of its corresponding checkbox.
     */ 
    setup_btn_lbl_field(ACTION2_ITEM_KEY, obj_has_action2_button(obj));
  
    /* Load Action2 (Extra) Label */  
    prop_field_set_value(&(mes->action2_label),
                        obj_get_action2_label(obj), False);

    /* Load Action3 (Extra) Button value. If the label is not
     * NULL or the empty string, then check the Action3
     * checkbox.
     */
    prop_checkbox_set_value(&(mes->action3_button), ACTION3_ITEM_KEY,
                        obj_has_action3_button(obj), False);
 
    /* Set the sensitivity of the label field according to
     * the state of its corresponding checkbox.
     */
    setup_btn_lbl_field(ACTION3_ITEM_KEY, obj_has_action3_button(obj));
     
    /* Load Action3 (Extra) Label */
    prop_field_set_value(&(mes->action3_label),
                        obj_get_action3_label(obj), False);
 
    /* Load Cancel Button value */
    prop_checkbox_set_value(&(mes->cancel_button), CANCEL_ITEM_KEY,
        		obj_has_cancel_button(obj), False);

    /* Load Help Button value */
    prop_checkbox_set_value(&(mes->help_button), HELP_ITEM_KEY,
        		obj_has_help_button(obj), False);

    /* Load Default Button */
    button = obj_get_default_btn(obj);
    prop_options_set_value(&(mes->default_btn), (XtPointer)button, False);

    turnoff_changebars();
       
    return OK;
}


static BOOL
msg_editor_pending(void)
{
    return(prop_changebars_pending(msg_editor_settings_rec.prop_sheet));
}

static BOOL
verify_name(void)
{
    BOOL		 retVal = TRUE; 
    MsgEditorSettingsRec *mes = &msg_editor_settings_rec;
 
    if (prop_changed(mes->name.changebar) && 
	!prop_name_ok(mes->current_obj, mes->name.field))
    {
        retVal = FALSE;
    }

    return (retVal);
}

static void
turnoff_changebars(void)
{
    MsgEditorSettingsRec *mes = &msg_editor_settings_rec;

    prop_set_changebar(mes->name.changebar,             PROP_CB_OFF);
    prop_set_changebar(mes->title.changebar,            PROP_CB_OFF);
    prop_set_changebar(mes->msg_type.changebar,      	PROP_CB_OFF);
    prop_set_changebar(mes->msg.changebar,              PROP_CB_OFF);
    prop_set_changebar(mes->action1_button.changebar,   PROP_CB_OFF);
    prop_set_changebar(mes->action2_button.changebar,   PROP_CB_OFF);
    prop_set_changebar(mes->action3_button.changebar,   PROP_CB_OFF);
    prop_set_changebar(mes->cancel_button.changebar,    PROP_CB_OFF);
    prop_set_changebar(mes->help_button.changebar,      PROP_CB_OFF);
    prop_set_changebar(mes->default_btn.changebar,      PROP_CB_OFF);

    prop_changebars_cleared(mes->prop_sheet);
}

static void
buttonCB(
    Widget   item,
    XtPointer clientdata,
    XmToggleButtonCallbackStruct *state
)
{
    int			 button;
    MsgEditorSettingsRec *mes = &msg_editor_settings_rec;
 
    XtVaGetValues(item, XmNuserData, &button, NULL);
    if (state->set)
    {
        setup_btn_lbl_field(button, True);
    }
    else
    {
        setup_btn_lbl_field(button, False);

	/* If the Action button checkbox has been unset,
	 * then set the message object's button label to NULL.
	 */
 	if (button == ACTION1_ITEM_KEY)
	    prop_field_set_value(&(mes->action1_label), "", False);
	else if (button == ACTION2_ITEM_KEY)
	    prop_field_set_value(&(mes->action2_label), "", False);
	else if (button == ACTION3_ITEM_KEY)
	    prop_field_set_value(&(mes->action3_label), "", False);
    }
}

static void
setup_btn_lbl_field(
    int         button,
    BOOL        value
)
{
    MsgEditorSettingsRec *mes = &msg_editor_settings_rec;
 
    switch (button)
    {
        case ACTION1_ITEM_KEY:
            ui_set_active(mes->action1_label.field, value);
            break;
        case ACTION2_ITEM_KEY:
            ui_set_active(mes->action2_label.field, value);
            break;
        case ACTION3_ITEM_KEY:
            ui_set_active(mes->action3_label.field, value);
            break;
	default:
	    break;
    }
}

static void
typeCB(
    Widget   item,
    XtPointer clientdata,
    XtPointer calldata
)
{
    int                 	value;
    STRING			label = NULL;
    MsgEditorSettingsRec	*mes = &msg_editor_settings_rec;
 
    XtVaGetValues(item, XmNuserData, &value, NULL);

    /* Change button labels to their default values, which
     * depend upon the type of messageBox that was chosen.
     */
    switch ( (AB_MESSAGE_TYPE) value)
    {  
        case AB_MSG_QUESTION:
	    /* Set the Action1 button, if it isn't already set
	     * and make its label "Yes". 
	     */
 	    if (!prop_checkbox_get_value(&(mes->action1_button),
		ACTION1_ITEM_KEY))
	    {
		prop_checkbox_set_value(&(mes->action1_button),
                	ACTION1_ITEM_KEY, True, True);
	    }
            label = ui_field_get_string(mes->action1_label.field);
            if ( !util_streq(label, msgEd_strings[MSG_ED_YES_STR]) )
                prop_field_set_value(&(mes->action1_label), 
			msgEd_strings[MSG_ED_YES_STR], True);

	    /* Set the Action2 button and make its label "No" */
 	    if (!prop_checkbox_get_value(&(mes->action2_button),
		ACTION2_ITEM_KEY))
	    {
		prop_checkbox_set_value(&(mes->action2_button),
                	ACTION2_ITEM_KEY, True, True);
	    }
            label = ui_field_get_string(mes->action2_label.field);
            if (!util_streq(label, msgEd_strings[MSG_ED_NO_STR]))
                prop_field_set_value(&(mes->action2_label), 
			msgEd_strings[MSG_ED_NO_STR], True);

            /* Unset the Action3 button and make its label empty */
            if ( prop_checkbox_get_value(&(mes->action3_button),
                ACTION3_ITEM_KEY) )
            {
                prop_checkbox_set_value(&(mes->action3_button),
                        ACTION3_ITEM_KEY, False, True);
            }
            label = ui_field_get_string(mes->action3_label.field);
            if (!util_strempty(label))
                prop_field_set_value(&(mes->action3_label), "", True);

	    /* Unset the Cancel button */
 	    if ( prop_checkbox_get_value(&(mes->cancel_button),
		CANCEL_ITEM_KEY) )
	    {
		prop_checkbox_set_value(&(mes->cancel_button),
                	CANCEL_ITEM_KEY, False, True);
	    }

	    /* Set the default button to be Action1 */
	    if ((XtPointer)prop_options_get_value(&(mes->default_btn)) != (XtPointer) AB_DEFAULT_BTN_ACTION1)	
	    {
		prop_options_set_value(&(mes->default_btn), 
				(XtPointer)AB_DEFAULT_BTN_ACTION1, True);
	    }
            break;

        case AB_MSG_ERROR:
            /* Unset the Action1 button and make its label empty */
 	    if (prop_checkbox_get_value(&(mes->action1_button),
		ACTION1_ITEM_KEY))
	    {
		prop_checkbox_set_value(&(mes->action1_button),
                	ACTION1_ITEM_KEY, False, True);
	    }
            label = ui_field_get_string(mes->action1_label.field);
            if (!util_strempty(label))
                prop_field_set_value(&(mes->action1_label), "", True);
 
	    /* Set the Action2 button and make its label "Retry" */
 	    if (!prop_checkbox_get_value(&(mes->action2_button),
		ACTION2_ITEM_KEY))
	    {
		prop_checkbox_set_value(&(mes->action2_button),
                	ACTION2_ITEM_KEY, True, True);
	    }
            label = ui_field_get_string(mes->action2_label.field);
            if (!util_streq(label, msgEd_strings[MSG_ED_RETRY_STR]))
                prop_field_set_value(&(mes->action2_label), 
			msgEd_strings[MSG_ED_RETRY_STR], True);

            /* Unset the Action3 button and make its label empty */
            if ( prop_checkbox_get_value(&(mes->action3_button),
                ACTION3_ITEM_KEY) )
            {
		prop_checkbox_set_value(&(mes->action3_button),
                        ACTION3_ITEM_KEY, False, True);
            }
            label = ui_field_get_string(mes->action3_label.field);
            if (!util_strempty(label)) 
                prop_field_set_value(&(mes->action3_label), "", True);

            /* Set Cancel button */
 	    if (!prop_checkbox_get_value(&(mes->cancel_button),
		CANCEL_ITEM_KEY))
	    {
		prop_checkbox_set_value(&(mes->cancel_button),
                	CANCEL_ITEM_KEY, True, True);
	    }

            /* Set the default button to be Cancel */ 
	    if ((XtPointer)prop_options_get_value(&(mes->default_btn)) != (XtPointer) AB_DEFAULT_BTN_CANCEL)	
	    {
		prop_options_set_value(&(mes->default_btn), 
                                (XtPointer)AB_DEFAULT_BTN_CANCEL, True);
	    }
            break;

        case AB_MSG_WARNING:
            /* Unset the Action1 button and make its label empty */
 	    if (prop_checkbox_get_value(&(mes->action1_button),
		ACTION1_ITEM_KEY))
	    {
		prop_checkbox_set_value(&(mes->action1_button),
                	ACTION1_ITEM_KEY, False, True);
	    }
            label = ui_field_get_string(mes->action1_label.field);
            if (!util_strempty(label))
                prop_field_set_value(&(mes->action1_label), "", True);
 
            /* Set the Action2 button and make its label "Continue" */
 	    if (!prop_checkbox_get_value(&(mes->action2_button),
		ACTION2_ITEM_KEY))
	    {
		prop_checkbox_set_value(&(mes->action2_button),
                	ACTION2_ITEM_KEY, True, True);
	    }
            label = ui_field_get_string(mes->action2_label.field);
            if (!util_streq(label, msgEd_strings[MSG_ED_CONT_STR]))
                prop_field_set_value(&(mes->action2_label), 
			msgEd_strings[MSG_ED_CONT_STR], True);
 
            /* Unset the Action3 button and make its label empty */
            if ( prop_checkbox_get_value(&(mes->action3_button),
                ACTION3_ITEM_KEY) )
            {
		prop_checkbox_set_value(&(mes->action3_button),
                        ACTION3_ITEM_KEY, False, True);
            }
            label = ui_field_get_string(mes->action3_label.field);
            if (!util_strempty(label)) 
                prop_field_set_value(&(mes->action3_label), "", True);

            /* Set Cancel button */
 	    if (!prop_checkbox_get_value(&(mes->cancel_button),
		CANCEL_ITEM_KEY))
	    {
		prop_checkbox_set_value(&(mes->cancel_button),
                	CANCEL_ITEM_KEY, True, True);
	    }

            /* Set the default button to be Action2 */ 
	    if ((XtPointer)prop_options_get_value(&(mes->default_btn)) != (XtPointer) AB_DEFAULT_BTN_ACTION2)	
	    {
		prop_options_set_value(&(mes->default_btn), 
                                (XtPointer)AB_DEFAULT_BTN_ACTION2, True);
	    }
            break;
 
        case AB_MSG_WORKING:
	    /* Set the Action1 button and make its label "Close" */
 	    if (!prop_checkbox_get_value(&(mes->action1_button),
		ACTION1_ITEM_KEY))
	    {
		prop_checkbox_set_value(&(mes->action1_button),
                	ACTION1_ITEM_KEY, True, True);
	    }
            label = ui_field_get_string(mes->action1_label.field);
            if (!util_streq(label, msgEd_strings[MSG_ED_CLOSE_STR]))
                prop_field_set_value(&(mes->action1_label), 
			msgEd_strings[MSG_ED_CLOSE_STR], True);
 
            /* Set the Action2 button and make its label "Stop" */
 	    if (!prop_checkbox_get_value(&(mes->action2_button),
		ACTION2_ITEM_KEY))
	    {
		prop_checkbox_set_value(&(mes->action2_button),
                	ACTION2_ITEM_KEY, True, True);
	    }
            label = ui_field_get_string(mes->action2_label.field);
            if (!util_streq(label, msgEd_strings[MSG_ED_STOP_STR])) 
                prop_field_set_value(&(mes->action2_label), 
			msgEd_strings[MSG_ED_STOP_STR], True);

            /* Unset the Action3 button and make its label empty */
            if ( prop_checkbox_get_value(&(mes->action3_button),
                ACTION3_ITEM_KEY) )
            {
		prop_checkbox_set_value(&(mes->action3_button),
                        ACTION3_ITEM_KEY, False, True);
            }
            label = ui_field_get_string(mes->action3_label.field);
            if (!util_strempty(label)) 
                prop_field_set_value(&(mes->action3_label), "", True);

	    /* Unset Cancel button */
 	    if (prop_checkbox_get_value(&(mes->cancel_button),
		CANCEL_ITEM_KEY))
	    {
		prop_checkbox_set_value(&(mes->cancel_button),
                	CANCEL_ITEM_KEY, False, True);
	    }

            /* Set the default button to be Action1 */ 
	    if ((XtPointer)prop_options_get_value(&(mes->default_btn)) != (XtPointer) AB_DEFAULT_BTN_ACTION1)	
	    {
		prop_options_set_value(&(mes->default_btn), 
                                (XtPointer)AB_DEFAULT_BTN_ACTION1, True);
	    }
            break;

        case AB_MSG_INFORMATION:
	    /* Set the Action1 button and make its label "OK" */
 	    if (!prop_checkbox_get_value(&(mes->action1_button),
		ACTION1_ITEM_KEY))
	    {
		prop_checkbox_set_value(&(mes->action1_button),
                	ACTION1_ITEM_KEY, True, True);
	    }
            label = ui_field_get_string(mes->action1_label.field);
            if (!util_streq(label, msgEd_strings[MSG_ED_OK_STR]))
                prop_field_set_value(&(mes->action1_label), 
			msgEd_strings[MSG_ED_OK_STR], True);
 
	    /* Unset Action2 button */
 	    if (prop_checkbox_get_value(&(mes->action2_button),
		ACTION2_ITEM_KEY))
	    {
		prop_checkbox_set_value(&(mes->action2_button),
                	ACTION2_ITEM_KEY, False, True);
	    }

            /* Unset the Action3 button and make its label empty */
            if ( prop_checkbox_get_value(&(mes->action3_button),
                ACTION3_ITEM_KEY) )
            {
		prop_checkbox_set_value(&(mes->action3_button),
                        ACTION3_ITEM_KEY, False, True);
            }
            label = ui_field_get_string(mes->action3_label.field);
            if (!util_strempty(label)) 
                prop_field_set_value(&(mes->action3_label), "", True);

	    /* Unset Cancel button */
 	    if (prop_checkbox_get_value(&(mes->cancel_button),
		CANCEL_ITEM_KEY))
	    {
		prop_checkbox_set_value(&(mes->cancel_button),
                	CANCEL_ITEM_KEY, False, True);
	    }

            /* Set the default button to be Action1 */ 
	    if ((XtPointer)prop_options_get_value(&(mes->default_btn)) != (XtPointer) AB_DEFAULT_BTN_ACTION1)	
	    {
		prop_options_set_value(&(mes->default_btn), 
                                (XtPointer)AB_DEFAULT_BTN_ACTION1, True);
	    }
            break;
    }
    /* Set the Message textpane label to the correct string */ 
    set_msg_textp_label((AB_MESSAGE_TYPE) value);

    /* Make button checkboxes & labels active or inactive
     * as appropriate.
     */
    setup_button_fields((AB_MESSAGE_TYPE)value);
}    

static void
setup_button_fields(
    AB_MESSAGE_TYPE mtype
)
{            
    MsgEditorSettingsRec *mes = &msg_editor_settings_rec;

    /* Make the Action3 button unchecked and the label
     * text field inactive.
     */
    ui_set_active(mes->action3_button.label, True);
    ui_set_active(mes->action3_button.checkbox, True);
    ui_set_active(mes->action3_label.field, False);

    switch (mtype)                                                    
    {
        case AB_MSG_ERROR:
	    /* Initially set the Action1 textfield to inactive,
	     * since the Action1 checkbox is not initially
	     * checked.
	     */
	    ui_set_active(mes->action1_label.field, False);
            ui_set_active(mes->action2_button.label, True);
            ui_set_active(mes->action2_button.checkbox, True);
            ui_set_active(mes->action2_label.field, True);
            ui_set_active(mes->cancel_button.label, True);
            ui_set_active(mes->cancel_button.checkbox, True);
            break;

        case AB_MSG_INFORMATION:
	    ui_set_active(mes->action1_label.field, True);
            ui_set_active(mes->action2_button.label, False);
            ui_set_active(mes->action2_button.checkbox, False);
            ui_set_active(mes->action2_label.field, False);
            ui_set_active(mes->cancel_button.label, False);
            ui_set_active(mes->cancel_button.checkbox, False);
            break;

        case AB_MSG_QUESTION:
        case AB_MSG_WARNING:
	    if (mtype == AB_MSG_QUESTION)
		ui_set_active(mes->action1_label.field, True);
	    else
		ui_set_active(mes->action1_label.field, False);
            ui_set_active(mes->action2_button.label, True);
            ui_set_active(mes->action2_button.checkbox, True);
            ui_set_active(mes->action2_label.field, True);
            ui_set_active(mes->cancel_button.label, True);
            ui_set_active(mes->cancel_button.checkbox, True);
            break;

        case AB_MSG_WORKING:
	    ui_set_active(mes->action1_label.field, True);
            ui_set_active(mes->action2_button.label, True);
            ui_set_active(mes->action2_button.checkbox, True);
            ui_set_active(mes->action2_label.field, True);
            ui_set_active(mes->cancel_button.label, False);
            ui_set_active(mes->cancel_button.checkbox, False);
            break;
    }
}

static void
set_msg_textp_label(
    AB_MESSAGE_TYPE mtype
)
{
    MsgEditorSettingsRec        *mes = &msg_editor_settings_rec;

    switch (mtype)
    {
        case AB_MSG_QUESTION:
            ui_set_label_string(mes->msg_textp_label, 
		CATGETS(Dtb_project_catd, 100, 210, "Question Message"));
	    break;
        case AB_MSG_ERROR:
            ui_set_label_string(mes->msg_textp_label, 
		CATGETS(Dtb_project_catd, 100, 211, "Error Message"));
	    break;
        case AB_MSG_WARNING:
            ui_set_label_string(mes->msg_textp_label, 
		CATGETS(Dtb_project_catd, 100, 212, "Warning Message"));
	    break;
        case AB_MSG_WORKING:
            ui_set_label_string(mes->msg_textp_label, 
		CATGETS(Dtb_project_catd, 100, 213, "Working Message"));
	    break;
        case AB_MSG_INFORMATION:
            ui_set_label_string(mes->msg_textp_label, 
		CATGETS(Dtb_project_catd, 100, 214, "Information Message"));
	    break;
	default:
	    break;
    }
}

/*
 * obj-callback: Called when a new project is opened or
 *		 when a new module is created or imported
 *		 or when an existing module is shown or hidden.
 */
static int
obj_updateOCB(
    ObjEvUpdateInfo     info
)
{
    Widget      	item = NULL;
    int			iRet = 0, numModItems = 0;
    AB_TRAVERSAL        trav;
    ABObj               mod = NULL;
    ABObj		project = proj_get_project();

    if (AB_msgEd_dialog != NULL)
    {
        if ( !obj_is_defined(info->obj) ||
	     (!obj_is_project(info->obj) && 
	      !obj_is_module(info->obj))
	   )
	{
            return iRet;
	}

	if (obj_is_module(info->obj))
	{
	    /* Created, Imported, or Shown Module. Either way,
	     * add it to the module optionmenu.
	     */
	    if (obj_has_flag(info->obj, MappedFlag))
	    {
		/* Make sure the "No Modules" optionmenu
		 * item is not visible, since a valid
		 * module is being added to the menu.
		 */
		XtUnmanageChild(NoModulesItem);
	
		if (!XtIsSensitive(dtb_message_ed_dialog.ctrl_panel))
		{
		    ui_set_active(dtb_message_ed_dialog.ctrl_panel, TRUE);
		}

		iRet = update_mod_opmenu(MOD_ADD, obj_get_name(info->obj),
					 NULL, &item, &numModItems);
		if (item != NULL)
		{
		    XtAddCallback(item, XmNactivateCallback,
			    change_msg_moduleCB, (XtPointer)info->obj);

		    /* If this is the first module to be shown,
		     * created, or imported, then set it to be
		     * the current message module.
		     */
		    if (MessageModule == NULL)
		    {
			ui_optionmenu_change_label(MsgModOpmenu, 
				obj_get_name(info->obj));
			MessageModule = info->obj;
		    }
		}
	    }
	    else	/* Hidden Module */
	    {
                iRet = update_mod_opmenu(MOD_DELETE, obj_get_name(info->obj),
                                         NULL, &item, &numModItems);
                /* Check if deleting the last module in the
                 * module optionmenu. 
                 */
                if (numModItems == 0)
                {
                    msg_editor_clear();
		    ui_set_active(dtb_message_ed_dialog.ctrl_panel, False);
		    ui_set_active(dtb_message_ed_dialog.ctrl_panel2, False);
		    ui_set_active(dtb_message_ed_dialog.ok_button, False);
		    ui_set_active(dtb_message_ed_dialog.apply_button, False);
		    ui_set_active(dtb_message_ed_dialog.reset_button, False);
                    XtManageChild(NoModulesItem);
		    ui_optionmenu_change_label(MsgModOpmenu, 
			msgEd_strings[MSG_ED_NO_MODULES_STR]);
                    MessageModule = (ABObj) NULL;
                }
		/* Check if deleting the current module. */
		else if (MessageModule == info->obj)
		{
                    /* Make another module in the
                     * optionmenu the current Module.
                     */
                    for (trav_open(&trav, project, AB_TRAV_MODULES);
                        (mod = trav_next(&trav)) != NULL; )
                    {
			if  ( obj_is_defined(mod) &&
                              obj_has_flag(mod, MappedFlag) &&
                              !obj_has_flag(mod, BeingDestroyedFlag)
			    )
			{
                            ui_optionmenu_change_label(MsgModOpmenu, 
					obj_get_name(mod));
                            MessageModule = mod;
			    XtUnmanageChild(NoModulesItem);
                            break;
			}
                    }
		}
	    }
	}
	/* Populate the Message Editor list with messages */
	if (MsgObjList != NULL)
	{
	    iRet = abobj_list_obj_updated(MsgObjList, info, 
				objlist_test_func);
	}
    }
    return (iRet);
}

/*
 * obj-callback: object is being destroyed - remove from Message
 *               Editor message list.
 */
static int
obj_destroyedOCB(
    ObjEvDestroyInfo    info
)
{
    int			iRet = 0, numModItems = 0;
    Widget		item = NULL;
    AB_TRAVERSAL	trav;
    ABObj		mod = NULL;
    ABObj		project = proj_get_project();

    if (AB_msgEd_dialog != NULL)
    {
        if ( !obj_is_defined(info->obj) ||
	     (!obj_is_project(info->obj) 
	      && !obj_is_module(info->obj) 
	      && !obj_is_message(info->obj))
	   )
	{
            return iRet;
	}

	if (obj_is_project(info->obj))
	{
	    /* Clear the Message Editor and make it inactive */
	    msg_editor_clear();
	    ui_set_active(dtb_message_ed_dialog.ctrl_panel, False);
	    ui_set_active(dtb_message_ed_dialog.ctrl_panel2, False);
	    ui_set_active(dtb_message_ed_dialog.ok_button, False);
	    ui_set_active(dtb_message_ed_dialog.apply_button, False);
	    ui_set_active(dtb_message_ed_dialog.reset_button, False);
	    MessageModule = (ABObj) NULL;
	    XtManageChild(NoModulesItem);	
	}
	else if (obj_is_module(info->obj))
	{
            iRet = update_mod_opmenu(MOD_DELETE, obj_get_name(info->obj),
                                     NULL, &item, &numModItems);
	    /* Check if deleting the last module in the
	     * module optionmenu.
	     */
	    if (numModItems == 0)
	    {
                msg_editor_clear();
		ui_set_active(dtb_message_ed_dialog.ctrl_panel, False);
		ui_set_active(dtb_message_ed_dialog.ctrl_panel2, False);
                ui_set_active(dtb_message_ed_dialog.ok_button, False); 
                ui_set_active(dtb_message_ed_dialog.apply_button, False); 
                ui_set_active(dtb_message_ed_dialog.reset_button, False); 
		XtManageChild(NoModulesItem);
		ui_optionmenu_change_label(MsgModOpmenu, 
			msgEd_strings[MSG_ED_NO_MODULES_STR]);
		MessageModule = (ABObj) NULL;
	    }
	    /* Check if deleting the current module. */
	    else if (MessageModule == info->obj)
	    {
		/* Make another module in the
		 * optionmenu the current Module.
		 */
		for (trav_open(&trav, project, AB_TRAV_MODULES);
		    (mod = trav_next(&trav)) != NULL; )
		{
		    if	( obj_is_defined(mod) &&
			  obj_has_flag(mod, MappedFlag) &&
			  !obj_has_flag(mod, BeingDestroyedFlag)
			)
		    {
			ui_optionmenu_change_label(MsgModOpmenu, 
				obj_get_name(mod));
			MessageModule = mod;
			XtUnmanageChild(NoModulesItem);
			break;
		    }
		}
		
	    }
	}
	else	/* Message object */
	{
	    iRet = abobj_list_obj_destroyed(MsgObjList, info->obj, 
				objlist_test_func);
	}
    }
    return (iRet);
}

static int
obj_renamedOCB(
    ObjEvAttChangeInfo    info
)
{
    Widget      list = NULL, item = NULL; 
    int		iRet = 0, numModItems = 0;
    STRING	mod_name = NULL;
 
    if (AB_msgEd_dialog != NULL) 
    { 
        if ( !obj_is_defined(info->obj) ||
	     (!obj_is_module(info->obj) && 
	      !obj_is_message(info->obj))
	   ) 
	{
            return iRet; 
	}

        if (obj_is_module(info->obj))
	{
            mod_name = obj_get_name(info->obj);
            if (mod_name == NULL)
	    {
                return -1;
	    }
 
            if (info->old_name != NULL)
	    {
                iRet = update_mod_opmenu(MOD_REPLACE, 
					 istr_string(info->old_name),
					 mod_name,
                                         &item, &numModItems);
	    }
	}
	else
	{
	    /* Check if the message obj is being created.
	     * If not, then simply replace the old name with
	     * the new name.  Otherwise let the obj_updateCB
	     * handle adding a newly created message object.
	     */
	    if (info->old_name != NULL)
	    {
		iRet = abobj_list_obj_renamed(MsgObjList, info->obj, 
			istr_string(info->old_name), objlist_test_func);
	    }
	}
    }
    return (iRet);
}

static int
msgEdP_msgpane_init(
   DtbMessageEdDialogInfo      cgen
)
{
    MsgEditorSettingsRec	*mes = &msg_editor_settings_rec;
    int				numModItems = 0;

    /* Build module optionmenu */
    numModItems = build_module_opmenu(cgen);

    /* Add Callback to load message object when selected from list */
    XtAddCallback(cgen->msg_list, XmNbrowseSelectionCallback,
            (XtCallbackProc)objlist_selectCB, (XtPointer)NULL);

    return (numModItems);
}

static int
build_module_opmenu(
   DtbMessageEdDialogInfo      cgen
)
{
    AB_TRAVERSAL	trav;
    ABObj		project, mod = NULL;
    STRING		name = NULL;
    Widget		item = NULL;
    int			i, numModItems = 0, iRet = 0;

    project = proj_get_project();
    for( (i = 0, trav_open(&trav, project, AB_TRAV_MODULES));
         (mod = trav_next(&trav)) != NULL; i++)
    {
	if (obj_has_flag(mod, MappedFlag) && obj_is_defined(mod))
	{
	    if (i == 0)
  	    {
		/* If there are mapped modules in the project,
		 * then make the "No Modules" item disappear
		 * and set the Current Module.
		 */
		XtUnmanageChild(NoModulesItem);
		MessageModule = mod;
	    }

	    name = obj_get_name(mod);
	    iRet = update_mod_opmenu(MOD_ADD, name, NULL, &item, &numModItems);
	    if (iRet != -1)
	    {
		XtAddCallback(item, XmNactivateCallback, 
			change_msg_moduleCB, (XtPointer) mod);
	    }
	}
    }

    return ((iRet < 0)? iRet : numModItems);
}

static void
change_msg_moduleCB(
    Widget	widget,
    XtPointer	clientData,
    XtPointer	callData
)
{
    MessageModule = (ABObj) clientData;
    XtUnmanageChild(NoModulesItem);
}

static void
objlist_selectCB(
    Widget      widget,
    XtPointer   client_data,
    XmListCallbackStruct *listdata
)
{
    ABObj               	module;
    ABObj               	selected_obj;
    STRING              	name = NULL;
    MsgEditorSettingsRec        *mes = &msg_editor_settings_rec;
 
    name = objxm_xmstr_to_str(listdata->item);
    if (name)
    {
        abobj_moduled_name_extract(name, &module, &selected_obj);
        util_free(name);

        if (selected_obj)
        {
            /* If there are pending changes, process the requested
             * load in a special way that allows the user to abort
             * if they so choose.
             */
            if ((mes->current_obj != NULL) &&
                  prop_changebars_pending(mes->prop_sheet)) 
	    {
                (void) msgEdP_do_auto_apply(widget, 
				mes->current_obj, selected_obj);
            }
            /* No pending changes, so just load the new object */
            else 
	    {
		if (!XtIsSensitive(dtb_message_ed_dialog.ctrl_panel2))
		    ui_set_active(dtb_message_ed_dialog.ctrl_panel2, TRUE);
		if (!XtIsSensitive(dtb_message_ed_dialog.ok_button))
		    ui_set_active(dtb_message_ed_dialog.ok_button, TRUE);
		if (!XtIsSensitive(dtb_message_ed_dialog.apply_button))
		    ui_set_active(dtb_message_ed_dialog.apply_button, TRUE);
		if (!XtIsSensitive(dtb_message_ed_dialog.reset_button))
		    ui_set_active(dtb_message_ed_dialog.reset_button, TRUE);
                msg_editor_load(selected_obj);
	    }
            return;
        }
    }
}

/*
 * Traverse the project and load all message objects. 
 */
static void
objlist_load(
   Widget      list
)
{
    ABObj           proj = proj_get_project();
    int             num_items = 0;
 
    if (proj == NULL || list == NULL)
        return;
 
    num_items = abobj_list_load(list, proj, objlist_test_func);
}

/*
 * Test whether an object should be loaded into the
 * Message Editor object list.
 */
static BOOL
objlist_test_func(
    ABObj test_obj
)
{
    ABObj	module = NULL;
    BOOL	should_add = FALSE;

    module = obj_get_module(test_obj);
    if (module && obj_is_defined(module) 
        && obj_has_flag(module, MappedFlag)
	&& obj_is_message(test_obj))
    {
	should_add = TRUE;
    }
    return(should_add);
}


static BOOL
verify_default_btn(void)
{
    MsgEditorSettingsRec *mes = &msg_editor_settings_rec;
    AB_DEFAULT_BUTTON	 default_btn = AB_DEFAULT_BTN_UNDEF;
    BOOL		 validButton = TRUE;

    default_btn = (AB_DEFAULT_BUTTON)prop_options_get_value(&(mes->default_btn));
    switch (default_btn)
    {
	case AB_DEFAULT_BTN_ACTION1:
	    if ( !prop_checkbox_get_value(&(mes->action1_button),
		ACTION1_ITEM_KEY) )
	    {
		dtb_message_ed_act1_def_btn_msg_initialize(
			&dtb_message_ed_act1_def_btn_msg);
		(void)dtb_show_modal_message(
			mes->action1_button.checkbox,
			&dtb_message_ed_act1_def_btn_msg,NULL,NULL,NULL);
		validButton = FALSE;
	    }
	    break;

	case AB_DEFAULT_BTN_ACTION2:
	    if ( !prop_checkbox_get_value(&(mes->action2_button),
		ACTION2_ITEM_KEY) )
	    {
		dtb_message_ed_act2_def_btn_msg_initialize(
			&dtb_message_ed_act2_def_btn_msg);
		(void)dtb_show_modal_message(
			mes->action2_button.checkbox,
			&dtb_message_ed_act2_def_btn_msg,NULL,NULL,NULL);
		validButton = FALSE;
	    }
	    break;

        case AB_DEFAULT_BTN_ACTION3:
            if ( !prop_checkbox_get_value(&(mes->action3_button),
                ACTION3_ITEM_KEY) )
            {
                dtb_message_ed_act3_def_btn_msg_initialize(
                        &dtb_message_ed_act3_def_btn_msg);
		(void)dtb_show_modal_message(
			mes->action3_button.checkbox,
                        &dtb_message_ed_act3_def_btn_msg,NULL,NULL,NULL);
                validButton = FALSE;
            }
            break;

	case AB_DEFAULT_BTN_CANCEL:
	    if ( !prop_checkbox_get_value(&(mes->cancel_button),
		CANCEL_ITEM_KEY) )
	    {
		dtb_message_ed_cancel_def_btn_msg_initialize(
			&dtb_message_ed_cancel_def_btn_msg);
		(void)dtb_show_modal_message(
			mes->cancel_button.checkbox,
			&dtb_message_ed_cancel_def_btn_msg,NULL,NULL,NULL);
		validButton = FALSE;
	    }
	    break;

	case AB_DEFAULT_BTN_NONE:
	    break;
    }

    return (validButton);
}

static BOOL
verify_label(void)
{
    MsgEditorSettingsRec *mes = &msg_editor_settings_rec;
    BOOL		 validLabel = TRUE;
    STRING		 label = (STRING) NULL;

    if ( prop_checkbox_get_value(&(mes->action1_button),
                ACTION1_ITEM_KEY) )
    {
	label = ui_field_get_string(mes->action1_label.field);
	if (util_strempty(label))
	{
	    dtb_message_ed_act1_lbl_msg_initialize(
			&dtb_message_ed_act1_lbl_msg);
	    (void)dtb_show_modal_message(mes->action1_label.field,
			&dtb_message_ed_act1_lbl_msg, NULL, NULL,NULL);
	    validLabel = FALSE;
	}
    }

    if ( prop_checkbox_get_value(&(mes->action2_button),
                ACTION2_ITEM_KEY) )
    {
	label = ui_field_get_string(mes->action2_label.field);
	if (util_strempty(label))
	{
	    dtb_message_ed_act2_lbl_msg_initialize(
			&dtb_message_ed_act2_lbl_msg);
	    (void)dtb_show_modal_message(mes->action2_label.field,
			&dtb_message_ed_act2_lbl_msg, NULL, NULL,NULL);
	    validLabel = FALSE;
	}
    }

    if ( prop_checkbox_get_value(&(mes->action3_button),
                ACTION3_ITEM_KEY) )
    {
        label = ui_field_get_string(mes->action3_label.field);
        if (util_strempty(label))
        {
            dtb_message_ed_act3_lbl_msg_initialize(
                        &dtb_message_ed_act3_lbl_msg);

	    (void)dtb_show_modal_message(mes->action3_label.field,
                        &dtb_message_ed_act3_lbl_msg, NULL, NULL,NULL);
            validLabel = FALSE;
        }
    }
    return (validLabel);
}

static BOOL
verify_buttons(void)
{
    MsgEditorSettingsRec *mes = &msg_editor_settings_rec;
    BOOL                 hasButtons = TRUE;

    if ( !prop_checkbox_get_value(&(mes->action1_button), 
				ACTION1_ITEM_KEY)  &&
	 !prop_checkbox_get_value(&(mes->action2_button), 
                                ACTION2_ITEM_KEY)  &&
	 !prop_checkbox_get_value(&(mes->action3_button), 
                                ACTION3_ITEM_KEY)  &&
	 !prop_checkbox_get_value(&(mes->cancel_button), 
                                CANCEL_ITEM_KEY)   &&
	 !prop_checkbox_get_value(&(mes->help_button), 
                                HELP_ITEM_KEY)
       )
    {
	dtb_message_ed_no_btns_msg_initialize(
		&dtb_message_ed_no_btns_msg);
	(void)dtb_show_modal_message(AB_msgEd_dialog,
                        &dtb_message_ed_no_btns_msg, NULL, NULL,NULL);
	hasButtons = FALSE;
    }

    return (hasButtons);
}

/*** DTB_USER_CODE_END
 ***
 *** End of user code section
 ***
 **************************************************************************/



void 
msgEdP_applyCB(
    Widget widget,
    XtPointer clientData,
    XtPointer callData
)
{
    /*** DTB_USER_CODE_START vvv Add C variables and code below vvv ***/

    MsgEditorSettingsRec       *mes = &msg_editor_settings_rec;

    (void) apply_changes(mes->current_obj);

    /*** DTB_USER_CODE_END   ^^^ Add C variables and code above ^^^ ***/
    
    /*** DTB_USER_CODE_START vvv Add C code below vvv ***/
    /*** DTB_USER_CODE_END   ^^^ Add C code above ^^^ ***/
}


void 
msgEdP_add_msgCB(
    Widget widget,
    XtPointer clientData,
    XtPointer callData
)
{
    /*** DTB_USER_CODE_START vvv Add C variables and code below vvv ***/

    ABObj			msg_obj = NULL;
    MsgEditorSettingsRec        *mes = &msg_editor_settings_rec;
    DtbMessageEdDialogInfo	cgen = NULL;
    int				ret = 0;
    DTB_MODAL_ANSWER		answer = DTB_ANSWER_NONE;

    /*
     * If there are pending changes, process the requested
     * load in a special way that allows the user to abort it
     * if they so choose.
     */  
    if ((mes->current_obj != NULL) &&
           prop_changebars_pending(mes->prop_sheet))
    {    
        answer = msgEdP_do_auto_apply(MsgObjList,
                        mes->current_obj, (ABObj) NULL);
	if (answer == DTB_ANSWER_CANCEL)
	    return;
    }

    msg_editor_clear();

    msg_obj = obj_create(AB_TYPE_MESSAGE, MessageModule);
    obj_set_unique_name(msg_obj, "message");
    obj_set_msg_type(msg_obj, AB_MSG_ERROR);
    obj_set_action2_label(msg_obj, msgEd_strings[MSG_ED_RETRY_STR]);
    obj_set_default_btn(msg_obj, AB_DEFAULT_BTN_ACTION2);

    /* Since we just create a new object for MessageModule,
     * we need to set the SaveNeeded flag on MessageModule.
     */
    abobj_set_save_needed(MessageModule, TRUE);

    cgen = (DtbMessageEdDialogInfo) clientData;
    ret = abobj_list_obj_created(cgen->msg_list, msg_obj, objlist_test_func);

    /* The message object was successfully added to the
     * Messages list. Select it and load its values.
     */
    if (ret > 0)
    {
	ui_list_select_item(cgen->msg_list, 
			abobj_get_moduled_name(msg_obj), TRUE);
	mes->current_obj = msg_obj;

        if (!XtIsSensitive(dtb_message_ed_dialog.ctrl_panel2))
	    ui_set_active(dtb_message_ed_dialog.ctrl_panel2, TRUE);
        if (!XtIsSensitive(dtb_message_ed_dialog.ok_button))
	    ui_set_active(dtb_message_ed_dialog.ok_button, TRUE);
        if (!XtIsSensitive(dtb_message_ed_dialog.apply_button))
	    ui_set_active(dtb_message_ed_dialog.apply_button, TRUE);
        if (!XtIsSensitive(dtb_message_ed_dialog.reset_button))
	    ui_set_active(dtb_message_ed_dialog.reset_button, TRUE);
    }
    else
    {
	/* This shouldn't happen because the message object 
	 * just created should always pass the objlist_test_func.
	 * If it doesn't (like somehow the MessageModule isn't
	 * mapped), then destroy it.
	 */
	obj_destroy(msg_obj);
    }

    /*** DTB_USER_CODE_END   ^^^ Add C variables and code above ^^^ ***/
    
    /*** DTB_USER_CODE_START vvv Add C code below vvv ***/
    /*** DTB_USER_CODE_END   ^^^ Add C code above ^^^ ***/
}


void 
msgEdP_del_msgCB(
    Widget widget,
    XtPointer clientData,
    XtPointer callData
)
{
    /*** DTB_USER_CODE_START vvv Add C variables and code below vvv ***/

    DtbMessageEdDialogInfo	cgen = NULL;
    Widget			list = NULL;
    ABObj               	module = NULL;
    ABObj               	selected_obj = NULL;
    STRING              	name = NULL;
    XmStringTable		selected_items = NULL;
    int				ret = 0;
    MsgEditorSettingsRec        *mes = &msg_editor_settings_rec;

    cgen = (DtbMessageEdDialogInfo) clientData;
    list = cgen->msg_list;
    XtVaGetValues(list, XmNselectedItems, &selected_items, NULL);
    if (selected_items == NULL)
	return;

    name = objxm_xmstr_to_str(selected_items[0]);
    if (name)
    {
	msg_editor_clear();
        abobj_moduled_name_extract(name, &module, &selected_obj);
        util_free(name);
        if (selected_obj)
	{
	    obj_destroy(selected_obj);
	}
	mes->current_obj = NULL;
	abobj_set_save_needed(MessageModule, TRUE);
    }

    /*** DTB_USER_CODE_END   ^^^ Add C variables and code above ^^^ ***/
    
    /*** DTB_USER_CODE_START vvv Add C code below vvv ***/
    /*** DTB_USER_CODE_END   ^^^ Add C code above ^^^ ***/
}


void 
msgEdP_show_msgCB(
    Widget widget,
    XtPointer clientData,
    XtPointer callData
)
{
    /*** DTB_USER_CODE_START vvv Add C variables and code below vvv ***/

    DtbMessageDataRec		mbr;
    MsgEditorSettingsRec        *mes = &msg_editor_settings_rec;
    ABObj			project = obj_get_project(mes->current_obj);
    STRING			str = (STRING) NULL;
    DTB_BUTTON			default_btn = DTB_NONE;
    unsigned char		dialogType = 0;

    /*** DTB_USER_CODE_END   ^^^ Add C variables and code above ^^^ ***/
    
    /*** DTB_USER_CODE_START vvv Add C code below vvv ***/

    if ((mes->current_obj == NULL) || 
	!obj_is_message(mes->current_obj))
    {
	return;
    }

    mbr.initialized = True;

    /* Set message dialog type */
    switch (obj_get_msg_type(mes->current_obj))
    {
        case AB_MSG_ERROR:
            dialogType = XmDIALOG_ERROR;
            break;
        case AB_MSG_INFORMATION:
            dialogType = XmDIALOG_INFORMATION;
            break;
        case AB_MSG_QUESTION:
            dialogType = XmDIALOG_QUESTION;
            break;
        case AB_MSG_WARNING:
            dialogType = XmDIALOG_WARNING;
            break;
        case AB_MSG_WORKING:
            dialogType = XmDIALOG_WORKING;
            break;
        default:
            break;
    }
    mbr.type = dialogType;

    /* Set message dialog title */
    str = obj_get_label(mes->current_obj);
    if (!util_strempty(str))
    {
	mbr.title = XmStringCreateLocalized(str);
    }
    else
    {
	mbr.title = NULL;
    }

    /* Set message dialog message string */
    str = obj_get_msg_string(mes->current_obj);
    if (!util_strempty(str))
    {
	mbr.message = XmStringCreateLocalized(str);
    }
    else 
    {   
        mbr.message = NULL; 
    }    

    /* Set message dialog action1 button (OK) label */
    str = obj_get_action1_label(mes->current_obj);
    if (!util_strempty(str))
    {
	mbr.action1_label = XmStringCreateLocalized(str); 
    }
    else 
    {   
        mbr.action1_label = NULL; 
    }    

    /* Set message dialog action2 button (extra) label */
    str = obj_get_action2_label(mes->current_obj);
    if (!util_strempty(str))
    {
	mbr.action2_label = XmStringCreateLocalized(str);
    }
    else 
    {   
        mbr.action2_label = NULL; 
    }    

    /* Set message dialog action3 button (extra) label */
    str = obj_get_action3_label(mes->current_obj);
    if (!util_strempty(str))
    {
        mbr.action3_label = XmStringCreateLocalized(str);
    }
    else
    {
        mbr.action3_label = NULL;
    }

    /* Set message dialog cancel button */
    mbr.cancel_button = obj_has_cancel_button(mes->current_obj); 

    /* Set message dialog help button */
    mbr.help_button = obj_has_help_button(mes->current_obj); 

    /* Set the default button */
    switch(obj_get_default_btn(mes->current_obj))
    {
        case AB_DEFAULT_BTN_ACTION1:
            default_btn = DTB_ACTION1_BUTTON;
            break;
        case AB_DEFAULT_BTN_ACTION2:
            default_btn = DTB_ACTION2_BUTTON;
            break;
        case AB_DEFAULT_BTN_ACTION3:
            default_btn = DTB_ACTION3_BUTTON;
            break;
        case AB_DEFAULT_BTN_CANCEL:
            default_btn = DTB_CANCEL_BUTTON;
            break;
        case AB_DEFAULT_BTN_NONE:
            default_btn = DTB_NONE;
            break;
        default:
            break;
    }
    mbr.default_button = default_btn;
    
    /* Set all callbacks to NULL */
    mbr.action1_callback = NULL;
    mbr.action2_callback = NULL;
    mbr.action3_callback = NULL;
    mbr.cancel_callback = NULL;

    /* Set Help Data to NULL */
    mbr.help_data.help_text = NULL;
    mbr.help_data.help_volume = "";
    mbr.help_data.help_locationID = "";

    /* Popup the message dialog */
    dtb_show_message(mes->prop_sheet, &mbr, NULL, NULL);

    /* Free data */
    if (mbr.title != NULL) 	XmStringFree(mbr.title);
    if (mbr.message != NULL) 	XmStringFree(mbr.message);
    if (mbr.action1_label != NULL) XmStringFree(mbr.action1_label);
    if (mbr.action2_label != NULL) XmStringFree(mbr.action2_label);
    if (mbr.action3_label != NULL) XmStringFree(mbr.action3_label);

    /*** DTB_USER_CODE_END   ^^^ Add C code above ^^^ ***/
}


void 
msgEdP_show_connCB(
    Widget widget,
    XtPointer clientData,
    XtPointer callData
)
{
    /*** DTB_USER_CODE_START vvv Add C variables and code below vvv ***/

    MsgEditorSettingsRec        *mes = &msg_editor_settings_rec;

    /*** DTB_USER_CODE_END   ^^^ Add C variables and code above ^^^ ***/
    
    /*** DTB_USER_CODE_START vvv Add C code below vvv ***/

    conn_set_source(mes->current_obj);
    conn_set_target(NULL);
    conn_popup_dialog(widget, (XtPointer)0, NULL);

    /*** DTB_USER_CODE_END   ^^^ Add C code above ^^^ ***/
}


void 
msgEdP_show_helpCB(
    Widget widget,
    XtPointer clientData,
    XtPointer callData
)
{
    /*** DTB_USER_CODE_START vvv Add C variables and code below vvv ***/

    MsgEditorSettingsRec        *mes = &msg_editor_settings_rec;

    /*** DTB_USER_CODE_END   ^^^ Add C variables and code above ^^^ ***/
    
    /*** DTB_USER_CODE_START vvv Add C code below vvv ***/

    ab_set_help_obj(mes->current_obj);
    ab_popup_help(widget,(XtPointer)0,NULL);

    /*** DTB_USER_CODE_END   ^^^ Add C code above ^^^ ***/
}


void 
msgEdP_resetCB(
    Widget widget,
    XtPointer clientData,
    XtPointer callData
)
{
    /*** DTB_USER_CODE_START vvv Add C variables and code below vvv ***/

    MsgEditorSettingsRec        *mes = &msg_editor_settings_rec;

    /*** DTB_USER_CODE_END   ^^^ Add C variables and code above ^^^ ***/
    
    /*** DTB_USER_CODE_START vvv Add C code below vvv ***/

    if (mes->current_obj != NULL)
    {
	msg_editor_load(mes->current_obj);
    }

    /*** DTB_USER_CODE_END   ^^^ Add C code above ^^^ ***/
}


void 
msgEdP_okCB(
    Widget widget,
    XtPointer clientData,
    XtPointer callData
)
{
    /*** DTB_USER_CODE_START vvv Add C variables and code below vvv ***/

    MsgEditorSettingsRec        *mes = &msg_editor_settings_rec;
    BOOL			ChangesApplied = TRUE;

    /*** DTB_USER_CODE_END   ^^^ Add C variables and code above ^^^ ***/
    
    /*** DTB_USER_CODE_START vvv Add C code below vvv ***/

    if (mes->current_obj != NULL)
    {
	ChangesApplied = apply_changes(mes->current_obj);
    }
    
    /* Dismiss the Message Editor if the changes were
     * applied successfully.  Otherwise, keep it up.
     */
    if (ChangesApplied)
	ui_win_show(AB_msgEd_dialog, False, XtGrabNone);

    /*** DTB_USER_CODE_END   ^^^ Add C code above ^^^ ***/
}


void 
msgEdP_cancelCB(
    Widget widget,
    XtPointer clientData,
    XtPointer callData
)
{
    /*** DTB_USER_CODE_START vvv Add C variables and code below vvv ***/
    /*** DTB_USER_CODE_END   ^^^ Add C variables and code above ^^^ ***/
    
    /*** DTB_USER_CODE_START vvv Add C code below vvv ***/

    msg_editor_clear();

    /* Dismiss the Message Editor */
    ui_win_show(AB_msgEd_dialog, False, XtGrabNone);

    /*** DTB_USER_CODE_END   ^^^ Add C code above ^^^ ***/
}



/**************************************************************************
 *** DTB_USER_CODE_START
 ***
 *** All automatically-generated data and functions have been defined.
 ***
 *** Add new functions here, or at the top of the file.
 ***/

static BOOL
apply_changes(
    ABObj	obj
)
{
    MsgEditorSettingsRec       *mes = &msg_editor_settings_rec;
    STRING                      value = NULL;
    ABObj			module = obj_get_module(obj);
 
    if (!verify_name() || !verify_default_btn() 
	|| !verify_label() || !verify_buttons())
    {
        return (FALSE);
    }

    if (prop_changed(mes->name.changebar))
    {
        value = ui_field_get_string(mes->name.field);
        obj_set_name(obj, value);
	abobj_set_save_needed(module, TRUE);
        util_free(value);
    }
    if (prop_changed(mes->title.changebar))
    {
        value = ui_field_get_string(mes->title.field);
        obj_set_label(obj, value);
	abobj_set_save_needed(module, TRUE);
        util_free(value);
    }
    /* The msg_type and msg fields in the Message
     * Editor both share the same changebar.
     */
    if (prop_changed(mes->msg_type.changebar))
    {
	if ( obj_get_msg_type(obj) !=
	    (AB_MESSAGE_TYPE)prop_options_get_value(&(mes->msg_type)))
	{
            obj_set_msg_type(obj,
		(AB_MESSAGE_TYPE)prop_options_get_value(&(mes->msg_type)));
	}
	abobj_set_save_needed(module, TRUE);
    }
    if (prop_changed(mes->msg.changebar))
    {
        value = ui_field_get_string(mes->msg.field);
	if (!util_streq(value, obj_get_msg_string(obj)))
	{
	    obj_set_msg_string(obj, value);
	}
        util_free(value);
	abobj_set_save_needed(module, TRUE);
    }
    /* This changebar is set when either the button checkbox
     * is changed or its corresponding textfield.
     */
    if (prop_changed(mes->action1_button.changebar))
    {
        value = ui_field_get_string(mes->action1_label.field);
        obj_set_action1_label(obj, value);
        util_free(value);
	abobj_set_save_needed(module, TRUE);
    }
    /* This changebar is set when either the button checkbox
     * is changed or its corresponding textfield.
     */
    if (prop_changed(mes->action2_button.changebar))
    {
        value = ui_field_get_string(mes->action2_label.field);
        obj_set_action2_label(obj, value);
        util_free(value);
	abobj_set_save_needed(module, TRUE);
    }
    /* This changebar is set when either the button checkbox
     * is changed or its corresponding textfield.
     */
    if (prop_changed(mes->action3_button.changebar))
    {  
        value = ui_field_get_string(mes->action3_label.field);
        obj_set_action3_label(obj, value);
        util_free(value);
        abobj_set_save_needed(module, TRUE);
    }
    if (prop_changed(mes->cancel_button.changebar))
    {
        obj_set_cancel_button(obj,
            prop_checkbox_get_value(&(mes->cancel_button), CANCEL_ITEM_KEY));
	abobj_set_save_needed(module, TRUE);
    }        
    if (prop_changed(mes->help_button.changebar))
    {
        obj_set_help_button(obj,
            prop_checkbox_get_value(&(mes->help_button), HELP_ITEM_KEY));
	abobj_set_save_needed(module, TRUE);
    }
    if (prop_changed(mes->default_btn.changebar))
    {
        obj_set_default_btn(obj,
		(AB_DEFAULT_BUTTON)prop_options_get_value(&(mes->default_btn)));
	abobj_set_save_needed(module, TRUE);
    }
    turnoff_changebars();

    return (TRUE);
}

/*
 * Handle auto apply.  This condition can occur in any of the
 * following ways:
 * - The user selects another object to be edited and hasn't
 *   yet saved changes made to the current object.
 *   (old_obj = current object, new_obj = new object they've
 *   chosen from the list)
 * - The user selects "Close" from the Motif window menu and
 *   hasn't yet saved changes made to the current object.
 *   (old_obj and new_obj are both = current object)
 * - The user presses the "Add Message" button and hasn't
 *   yet saved changes made to the current object.  
 *   (old_obj = current object, new_obj = NULL)
 * The assumption here is that the user wants to be given the
 * opportunity to save the changes or discard them, and a modal
 * dialog is an o.k. way to handle the situation.
 */
static DTB_MODAL_ANSWER
msgEdP_do_auto_apply(
    Widget      list,
    ABObj       old_obj,
    ABObj       new_obj
)
{
    DTB_MODAL_ANSWER    answer = DTB_ANSWER_NONE;
    char                buffer[256];
    STRING              old_name = NULL,
                        new_name = NULL;
    BOOL                ChangingObjects = FALSE,
                        ChangesApplied = FALSE;
    XmString            xm_buf = (XmString) NULL;
    DtbObjectHelpData   help_data = NULL;

    *buffer = 0;
    if (old_obj == (ABObj) NULL)
        return (DTB_ANSWER_CANCEL);
    else
        old_name = abobj_get_moduled_name(old_obj);

    if (new_obj == (ABObj) NULL)
        new_name = "";
    else
        new_name = abobj_get_moduled_name(new_obj);

    /* Check for adding a new message auto-apply vs. 
     * same object auto-apply.
     */
    if( (new_obj != (ABObj) NULL) && (new_obj != old_obj) )
        ChangingObjects = TRUE;

    if (dtb_app_resource_rec.implied_apply == True)
        answer = DTB_ANSWER_ACTION1;
    else
    {
    	help_data = (DtbObjectHelpData) util_malloc(sizeof(DtbObjectHelpDataRec));
    	help_data->help_volume = NULL;
    	help_data->help_locationID = NULL;
 
    	if (ChangingObjects)
    	{
            sprintf(buffer, CATGETS(Dtb_project_catd, 100, 36,
                "Properties for \"%s\" have been modified but not\
                Applied.\nApply Changes or Cancel Load operation\
                for \"%s\"."), old_name, new_name);
	    help_data->help_text = CATGETS(Dtb_project_catd, 100, 98,
"Click Apply Changes to apply the changes to the\ncurrent message and load the selected message.\n\nClick Cancel if you don't want to apply the\nchanges to the current message. You can then\nclick Reset to undo the changes before loading\nthe selected message.");
    	}
    	else
    	{
            if (new_obj != (ABObj) NULL)
       	    {
		sprintf(buffer, CATGETS(Dtb_project_catd, 100, 35,
                "Properties for \"%s\" have been modified but not\
                Applied.\nApply Changes or Cancel Close operation."),
                old_name);
		help_data->help_text = CATGETS(Dtb_project_catd, 100, 99,
"Click Apply Changes to apply the changes to the\ncurrent message and close the Message Editor.\n\nClick Cancel if you don't want to apply the\nchanges to the current message and want the\nMessage Editor to remain displayed. You can\nthen click Reset to undo the changes before\nclosing the Message Editor.");
            }
            else
            {
		sprintf(buffer,CATGETS(Dtb_project_catd, 100, 39,
                "Properties for \"%s\" have been modified but not\
                Applied.\nApply Changes or Cancel Add-Message\
                operation."), old_name);
		help_data->help_text = CATGETS(Dtb_project_catd, 100, 100,
"Click Apply Changes to apply the changes to the\ncurrent message and add a new message to the\nmodule.\n\nClick Cancel if you don't want to apply the\nchanges to the current message. You can then\nclick Reset to undo the changes before adding\na new message.");
            }
    	}
 
    	/* Popup modal message and wait for answer */
 
    	xm_buf = XmStringCreateLocalized(buffer);
    	dtb_message_ed_wrn_msg_initialize(&dtb_message_ed_wrn_msg);
    	answer = dtb_show_modal_message(list, &dtb_message_ed_wrn_msg,
                                    xm_buf, help_data, NULL);
    	XmStringFree(xm_buf);
    	util_free(help_data);
    }

    /* Process answer */
    switch (answer)
    {
        case DTB_ANSWER_ACTION1: /* Apply Changes */
            ChangesApplied = apply_changes(old_obj);
            if (ChangesApplied)
            {
                if (ChangingObjects)
                {
                    msg_editor_load(new_obj);
                }
            }
            else  /* The changes were not successfully applied */
            {
                if (ChangingObjects)
                {
                    ui_list_select_item(list, old_name, FALSE);
                }
		/* If the changes were not successfully applied
		 * and the operation was either a Motif window
		 * menu Close or Adding a new message, then
		 * cancel the operation.
		 */
                else
                {
                    answer = DTB_ANSWER_CANCEL;
                }
            }
            break;
        case DTB_ANSWER_CANCEL: /* Cancel */
            if (ChangingObjects)
            {
                util_dprintf(2,"Resetting <%s> as the current item\n",
                        old_name);
                ui_list_select_item(list, old_name, FALSE);
            }
            break;
    }        

    if (old_obj != (ABObj)NULL) XtFree(old_name);
    if (new_obj != (ABObj)NULL) XtFree(new_name);
 
    /* Pass along the answer in case the caller needs it */
    return (answer);
}

/*
 * Called when the user attempts to dismiss the Message Editor
 * via the Motif window menu.
 */
static void
msgEdP_prevent_closeCB( 
    Widget      widget,
    XtPointer   client_data,
    XtPointer   call_data
)
{
    DTB_MODAL_ANSWER            answer = DTB_ANSWER_NONE;
    MsgEditorSettingsRec        *mes = &msg_editor_settings_rec;
 
    /* 
     * If there are pending changes for the current object,
     * handle the implied auto-apply.
     */
    if	( (mes->current_obj != NULL) &&
	  prop_changebars_pending(mes->prop_sheet)
	)
    {
        answer = msgEdP_do_auto_apply(widget, mes->current_obj,
				      mes->current_obj);
	if (answer == DTB_ANSWER_ACTION1)
	    ui_win_show(AB_msgEd_dialog, False, XtGrabNone);
    }
    else
    {   
         /* No pending changes. Just dismiss the 
	  * Message Editor. 
	  */
   	ui_win_show(AB_msgEd_dialog, False, XtGrabNone);
    }
}

static int
update_mod_opmenu(
    MOD_OP	op,
    STRING	item_str,
    STRING	new_item_str,
    Widget	*RetItem,
    int		*ModItemCount
)
{
    static int	NumModItems = 0;
    Widget	item = NULL;
    int		iRet = 0;

    switch (op)
    {
	case MOD_ADD:
	    if (item_str != NULL)
	    {
		/* If the item is not already in the optionmenu, add it. */
		item = ui_optionmenu_find_item( MsgModOpmenu, item_str);
		if (item == NULL)
		{
		    item = ui_optionmenu_add_item(MsgModOpmenu, item_str);
		    if (item != NULL)
			NumModItems++;
		    else
			iRet = -1;
		}
	    }
	    else
	    {
		iRet = -1;
	    }
	break;
	case MOD_DELETE: 
	    if (item_str != NULL)
	    {
		iRet = ui_optionmenu_delete_item(MsgModOpmenu, item_str);
		if (iRet == 0) NumModItems--;
	    }
	    else
	    {
		iRet = -1;
	    }
	break;
	case MOD_REPLACE:
 	    if ((item_str != NULL) && (new_item_str != NULL))
	    {
		item = ui_optionmenu_replace_item(MsgModOpmenu, 
					item_str, new_item_str);
	    }
	    else 
	    {
		iRet = -1;
	    }
	break;

 	default:
		break;
    }
    
    *RetItem = item;
    *ModItemCount = NumModItems;

    return (iRet); 
}

static void
msgEdP_strings_init(void)
{
    msgEd_strings[MSG_ED_RETRY_STR] = 
	XtNewString(CATGETS(Dtb_project_catd, 100, 202, "Retry"));
    msgEd_strings[MSG_ED_OK_STR] = 
	XtNewString(CATGETS(Dtb_project_catd, 100, 203, "OK"));
    msgEd_strings[MSG_ED_CLOSE_STR] = 
	XtNewString(CATGETS(Dtb_project_catd, 100, 204, "Close"));
    msgEd_strings[MSG_ED_STOP_STR] = 
	XtNewString(CATGETS(Dtb_project_catd, 100, 205, "Stop"));
    msgEd_strings[MSG_ED_YES_STR] = 
	XtNewString(CATGETS(Dtb_project_catd, 100, 206, "Yes"));
    msgEd_strings[MSG_ED_NO_STR] = 
	XtNewString(CATGETS(Dtb_project_catd, 100, 207, "No"));
    msgEd_strings[MSG_ED_CONT_STR] = 
	XtNewString(CATGETS(Dtb_project_catd, 100, 208, "Continue"));
    msgEd_strings[MSG_ED_NO_MODULES_STR] = 
	XtNewString(CATGETS(Dtb_project_catd, 100, 209, "No Modules"));
}

/*** DTB_USER_CODE_END
 ***
 *** End of user code section
 ***
 **************************************************************************/


