/*
 *   cddbd - CD Database Protocol Server
 *
 *   Copyright (C) 1996  Steve Scherf
 *   Email: steve@moonsoft.com
 *   Moondog Software Productions - makers of fine public domain software.
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef LINT
static char *_cddbd_h_ident_ = "@(#)$Id: cddbd.h,v 1.5 1996/12/13 23:35:22 steve Exp $";
#endif


/* Preprocessor definitions. */

#define TMPDIR		"/tmp"

#define SECS_PER_MIN	60
#define SECS_PER_HOUR	(SECS_PER_MIN * 60)
#define SECS_PER_DAY	(SECS_PER_HOUR * 24)
#define SECS_PER_WEEK	(SECS_PER_DAY * 7)

/* Protocol flags. */
#define P_QUOTE		0x00000001

#define PROTO_ENAB(flag)	(proto_flags[level] & (flag))

/* Operation modes. */
#define MODE_NONE	-1
#define MODE_SERV	0
#define MODE_DB		1
#define MODE_MAIL	2
#define NMODE		3

/* Exit codes. */
#define QUIT_OK		0
#define QUIT_ERR	1
#define QUIT_RETRY	2

/* Logging flags. */
#define LOG_HELLO	0x0001
#define LOG_INFO	0x0002
#define LOG_ERR		0x0004
#define LOG_ACCESS	0x0008
#define LOG_INPUT	0x0010
#define LOG_QUERY	0x0020
#define LOG_UQUERY	0x0040
#define LOG_FUZZY	0x0080
#define LOG_HASH	0x0100
#define LOG_LOCK	0x0200
#define LOG_READ	0x0400
#define LOG_WRITE	0x0800
#define LOG_NET		0x1000
#define LOG_UPDATE	0x2000
#define LOG_MAIL	0x4000
#define LOG_XMIT	0x8000
#define LOG_NONE	0x0000
#define LOG_ALL		0xFFFF

/* Remote ops. */
#define RMT_OP_NONE	-1
#define RMT_OP_CATCHUP	0
#define RMT_OP_LOG	1
#define RMT_OP_TRANSMIT	2
#define NROPS		3

/* Parsing flags. */
#define PF_HONOR_QUOTE	0x00000001
#define PF_REMAP_QSPC	0x00000002

/* DB function error codes. */
#define DE_NO_ERROR	0		/* DB entry is okay. */
#define DE_NOMEM	1		/* No memory for data structures. */
#define DE_FILE		2		/* File access error. */
#define DE_SYSERR	3		/* System call error. */
#define DE_INTERNAL	4		/* Internal parsing error (bug). */
#define DE_INVALID	5		/* Database entry is invalid. */

/* Defines for getsiteent. */
#define SITE_XMIT	0
#define SITE_LOG	1
#define SITE_INFO	2

/* DB function flags. */
#define DF_STDIN	0x00000001	/* File is being read from stdin. */
#define DF_MAIL		0x00000002	/* File is an email submission. */
#define DF_DONE		0x00000004	/* DB entry has been read. */
#define DF_REMAP	0x00000008	/* Entry contains RFC 1521 remaps. */
#define DF_CK_REMAP	0x00000010	/* Entry may contain RFC 1521 remaps. */
#define DF_SUBMITTER	0x00000020	/* Entry has a "submitted via" field. */

/* DB parsing phases. */
#define DP_COMMENT	0
#define DP_DISCID	1
#define DP_DTITLE	2
#define DP_TTITLE	3
#define DP_EXTD		4
#define DP_EXTT		5
#define DP_PLAYORDER	6
#define DP_NPHASE	7

/* Mail flags. */
#define MF_FAIL		0x00000001	/* Failed submission email. */
#define MF_TEST		0x00000002	/* Test submission email. */

/* Dup entry policy. */
#define	DUP_NEVER	0
#define	DUP_ALWAYS	1
#define	DUP_COMPARE	2
#define	DUP_DEFAULT	DUP_COMPARE

/* Default permissions. */
#define PERM_DEF_GET	0
#define PERM_DEF_WRITE	0
#define PERM_DEF_DUP	0
#define PERM_DEF_UPDATE	0
#define PERM_DEF_CONN	1

/* Mail encoding types. */
#define CE_QUOTED_PRINT		0
#define CE_7BIT			1
#define CE_8BIT			2

/* Charset types (only care about iso-8859-1). */
#define CC_ISO_8859_1		2

/* Timers. */
#define INPUT_TIMER	0
#define ACCESS_TIMER	1
#define CONNECT_TIMER	2


/* Constants. */
#define CDDBHOSTNAMELEN	64	/* Max host name length. */
#define DBLINESIZ	80	/* Max number of chars in a DB entry. */
#define CDDBBUFSIZ	256	/* Max input buffer size. */
#define CDDBARGSZ	128	/* Max input arg size. */
#define CDDBPATHSZ	128	/* Max pathname buffer size. */
#define CDDBCATEGSZ	32	/* Max category name size. */
#define CDDBOUTSIZ	80	/* Max output buffer size. */
#define CDDBMAXTRK	99	/* Max number of tracks on a CD. */
#define CDDBLCKNAMLEN	8	/* Length of lock file prefix. */
#define CDDBDISCIDLEN	8	/* Length of database file name. */
#define CDDBFRAMEPERSEC	75	/* Number of frames in a second. */
#define CDDBMAXDBDIR	50	/* Max number of database subdirectories. */
#define CDDBMAXERR	3	/* Max number of allowable errors. */
#define CDDBMINREV	1	/* Min entry revision level. */
#define MIN_LINES	100	/* Min number of lines in a database entry. */
#define NCLIENT		30	/* Max number of client names to log. */
#define MAX_LOCK_LOOP	100	/* Max number of tries to get a lock. */
#define MIN_PROTO_LEVEL	1	/* Minimum protocol level supported. */
#define MAX_PROTO_LEVEL	2	/* Protocol level this server supports. */
#define DEF_PROTO_LEVEL	1	/* Default protocol level. */
#define DEF_XMIT_TO	60	/* Default transmit timeout. */
#define DEF_INPUT_TO	60	/* Default input timeout. */
#define DEF_ACCESS_TO	60	/* Default access timeout. */
#define DEF_CONNECT_TO	600	/* Default connect timeout. */
#define DEF_MAX_LINES	1024	/* Default max post size. */
#define DEF_MAX_USERS	100	/* Default max users. */
#define DEF_MAX_XMITS	2	/* Default max transmits. */
#define DEF_LOG_HIWAT	150000	/* Default log high water mark. */
#define DEF_LOG_LOWAT	100000	/* Default log low water mark. */
#define DEF_DIR_MODE	0755	/* Default mode for directory creation. */
#define DEF_FILE_MODE	0644	/* Default mode for file creation. */
#define DEF_FUZZ_FACT	900	/* Default fuzzy factor. */
#define DEF_FUZZ_DIV	4	/* Default fuzzy divisor. */

#define MIN_CHECK_LEVEL	1	/* Min DB checking level. */
#define MAX_CHECK_LEVEL	2	/* Max DB checking level. */
#define CL_REMAP	2	/* DB checking level for charset remaps. */


/* Structure definitions. */

typedef int db_errno_t;
typedef int proto_t;

#define CT_INPUT_RST	0x00000001	/* Reset timer on input. */
#define CT_ACCESS_RST	0x00000002	/* Reset timer on successful access. */
#define CT_WRITE_DIS	0x00000004	/* Disable timer if write allowed. */

/* Timer struct definition. */
typedef struct ctimer {
	char 	*name;		/* Timer name. */
	void	(*func)(void);	/* Routine to invoke at timeout. */
	int	flags;		/* Timer flags. */
	long	seconds;	/* Seconds until a timeout. */
	long	left;		/* Seconds left until next timeout. */
} ctimer_t;


/* Services table indices. */
#define SERV_CDDBP	0
#define SERV_SMTP	1

/* Local servent structure. */
typedef struct cddbd_servent {
	char *s_name;
	char *s_proto;
	int s_port;
} cservent_t;


/* Log struct definition. */

#define L_NOSHOW	0x00000001

typedef struct log {
	unsigned short	flag;		/* Flag. */
	int		cnt;		/* Message count. */
	int		dflag;		/* Display flags. */
	char	        *name;		/* Log flag name. */
	char	        *banr;		/* Banner. */
} log_t;


/* Command struct definition. */
#define CF_HELLO	0x00000001	/* Hello is necessary first. */
#define CF_SUBCMD	0x00000002	/* This command has subcommands. */
#define CF_ACCESS	0x00000004	/* This command accesses the database. */

typedef struct cmd {
	char	*cmd;			/* Command string. */
	void	(*func)();		/* Command function. */
	char	**help;			/* Help string. */
	int	flags;			/* Command flags. */
} cmd_t;


/* Access field type definition. */
#define AC_PATH		0		/* This is a pathname. */
#define AC_NUMERIC	1		/* This is numeric. */
#define AC_USER		2		/* This is a user name. */
#define AC_GROUP	3		/* This is a group name. */
#define AC_STRING	4		/* This is a generic string. */
#define AC_MODE		5		/* This is a octal file mode. */

#define AF_ZERO		0x00000001	/* Numeric arg has a min 0 value. */
#define AF_NONZ		0x00000002	/* Numeric arg has a min 1 value. */
#define AF_NODEF	0x00000004	/* No default value. */

typedef struct access {
	char	*at_fname;		/* Field name. */
	void	*at_addr;		/* Where to put the value. */
	int	at_type;		/* Field type. */
	int	at_flags;		/* Access flags. */
	int	at_def;			/* Default value. */
} access_t;


/* Argument structure definition. */
#define MAXARGS		110
#define CMDLEN		1024

typedef struct arg {
	int nargs;
	int nextarg;
	char *arg[MAXARGS];
	char buf[CMDLEN];
} arg_t;


/* Month struct definition. */
#define NMONTH		12
#define LEAPDAY		29
#define LEAPMONTH	1
#define LEAPYEAR(y)	(!(y % 4))

typedef struct month {
	char *name;
	int ndays;
} month_t;


/* Defines for db_t flags. */
#define DB_DISCLEN	0x00000001
#define DB_OFFSET	0x00000002
#define DB_REVISION	0x00000004
#define DB_SUBMITTER	0x00000008
#define DB_REMAP	0x00000010
#define DB_REMAPPABLE	0x00000020
#define DB_PROCESSOR	0x00000040

/* Defines for db_t.db_rev. */
#define DB_MAX_REV	-1

/* Database entry struct. */
typedef struct db {
	int db_flags;
	int db_rev;
	int db_offset[CDDBMAXTRK];
	short db_disclen;
	char db_trks;
	lhead_t *db_phase[DP_NPHASE];
} db_t;


#define PF_MULTI	0x00000001
#define PF_STRIP	0x00000002
#define PF_NUMERIC	0x00000004
#define PF_REQUIRED	0x00000008
#define PF_IGNORE	0x00000010
#define PF_FILL		0x00000020

/* DB field descriptions. */
typedef struct db_parse {
	char *dp_str;
	char *dp_name;
	char *dp_pstr;
	int dp_flags;
} db_parse_t;


/* Lock struct. */
typedef struct clck {
	char lk_name[CDDBLCKNAMLEN + 1];
	int lk_refcnt;
} clck_t;


/* World coordinate structure. */
typedef struct coord {
	char co_compass;
	int co_degrees;
	int co_minutes;
} coord_t;


/* Remote site file entry struct. */
#define ST_PROTO_NONE	0
#define ST_PROTO_CDDBP	1
#define ST_PROTO_SMTP	2

typedef struct site {
	char st_name[CDDBHOSTNAMELEN + 1];
	char st_user[CDDBBUFSIZ];
	char st_desc[CDDBBUFSIZ];
	int st_proto;
	int st_port;
	coord_t st_lat;
	coord_t st_long;
} site_t;


/* MIME encoding. */
typedef struct encode {
	char *en_type;
	void (*en_mapfunc)();
} encode_t;


/* External prototypes. */

void _quit(int, int);
void cddbd_build_fuzzy(void);
void cddbd_check_db(int, int);
void cddbd_lock_free(clck_t *);
void cddbd_log();
void cddbd_mail(void);
void cddbd_parse_args(arg_t *, int);
void cddbd_rmt_op(int, char *, char *);
void cddbd_serve(void);
void cddbd_snprintf();
void cddbd_stand(int);
void cddbd_unlock(clck_t *);
void cddbd_update(void);
void cddbp_close(void);
void copy_coord(char *, coord_t *);
void cvt_time(time_t, char *);
void db_free(db_t *);
void db_link(db_t *, char *, char *, int);
void db_strcpy(db_t *, int, int, char *, int);
void db_unlink(char *, char *);
void do_cddb_query_fuzzy(arg_t *);
void endsiteent(void);
void get_rmt_hostname(int, char *);
void quit(int);
void rfc_1521_qp_map(unsigned char *);
void setsiteent(void);
void smtp_close(void);
void strip_crlf(char *);

int *cddbd_count(void);
int categ_index(char *);
int cddbd_count_history(char *);
int cddbd_close_history(void);
int cddbd_fix_file(char *, int, int, int);
int cddbd_fork(void);
int cddbd_getchar(void);
int cddbd_link(char *, char *);
int cddbd_lock(clck_t *, int);
int cddbd_merge_ulist(char *, int);
int cddbd_strcasecmp(char *, char *);
int cddbd_strncasecmp(char *, char *, int);
int cddbd_timer_sleep(ctimer_t *);
int cddbd_write_ulist(char *, char *);
int cddbp_log_stats(void);
int cddbp_open(char *, int);
int cddbp_transmit(db_t *, char *, unsigned int);
int cddbp_update(void);
int db_post(db_t *, char *, unsigned int, char *);
int db_write(FILE *fp, db_t *);
int is_blank(char *, int);
int is_dot(char *);
int is_fuzzy_match(int *, int *, int);
int is_instr(char, char *);
int is_parent_dir(char *);
int is_space(char);
int match_host(char *);
int smtp_open(void);
int smtp_transmit(FILE *, char *, char *, char *, int, int);

char *cddbd_gets(char *, int);
char *cddbd_strcasestr(char *, char *);
char *get_time(int);
char *make_time(struct tm *);
char *make_time2(struct tm *);

short get_serv_port(int, int);

site_t *getsiteent(int);
site_t *getsitenam(char *, int);

db_t *db_read(FILE *, char *, int);

clck_t *cddbd_lock_alloc(char *);

struct tm *date_to_tm(char *);


/* External definitions. */

extern int build_fuzzy;
extern int curpid;
extern int db_dir_mode;
extern int db_errno;
extern int db_file_mode;
extern int db_gid;
extern int db_uid;
extern int dir_mode;
extern int dup_ok;
extern int dup_policy;
extern int file_mode;
extern int fuzzy_div;
extern int fuzzy_factor;
extern int gid;
extern int hdrlen;
extern int max_lines;
extern int max_xmits;
extern int prclen;
extern int sublen;
extern int test_mail;
extern int trklen;
extern int uid;
extern int verbose;
extern int write_ok;
extern int xmit_time;

extern char *categlist[];
extern char *cddb_help[];
extern char *char_types[];
extern char *content_encoding;
extern char *content_len;
extern char *content_type;
extern char *db_errmsg[];
extern char *from;
extern char *get_help[];
extern char *hdrstr;
extern char *hello_help[];
extern char *help_help[];
extern char *help_info[];
extern char *log_help[];
extern char *mailprefix;
extern char *mime_ver;
extern char *motd_help[];
extern char *prcstr;
extern char *proto_help[];
extern char *query_help[];
extern char *quit_help[];
extern char *read_help[];
extern char *respprefix;
extern char *rpath;
extern char *sites_help[];
extern char *srch_help[];
extern char *stat_help[];
extern char *subj;
extern char *substr;
extern char *tfuzzfile;
extern char *tmpdir;
extern char *to;
extern char *trkstr;
extern char *update_help[];
extern char *ver_help[];
extern char *verstr;
extern char *verstr2;
extern char *whom_help[];
extern char *write_help[];
extern char *xsender;
extern char admin_email[];
extern char bounce_email[];
extern char cddbdir[];
extern char dupdir[];
extern char hashdir[];
extern char histfile[];
extern char host[];
extern char postdir[];
extern char rhost[];
extern char sitefile[];
extern char smtphost[];
extern char thistfile[];
extern char uhistfile[];
extern char user[];

extern short log_flags;

extern clck_t *lock_log;
extern clck_t *lock_hash;
extern clck_t *lock_hist;
extern clck_t *lock_nus;
extern clck_t *lock_tfuzz;
extern clck_t *lock_update;

extern proto_t proto_flags[];
extern ctimer_t timers[];
extern encode_t encoding_types[];
