cdb is a fast, reliable, simple package
for creating and reading constant databases.
The cdb database structure provides several features:

* **Fast lookups:**
  A successful lookup in a large database
  normally takes just two disk accesses.
  An unsuccessful lookup takes only one.

* **Low overhead:**
  A database uses 2048 bytes (or 4096 bytes for cdb64),
  plus 24 bytes per record (or 48 bytes per record for cdb64),
  plus the space for keys and data.

* **No random limits:**
  cdb handles any database up to 4 gigabytes
  (or up to an exabyte for cdb64).
  There are no other restrictions.
  Records are streamed and don't have to fit into memory.
  Databases are stored in a machine-independent format
  (one format for cdb, one format for cdb64).

* **Fast atomic database replacement:**
  `cdbmake` rewrites an entire database
  much more quickly than other hashing packages.
  Database replacement is safe against system crashes.
  Readers don't pause during a rewrite:
  they continue transparently using the old database
  until the new database is in place.

* **Fast database dumps:**
  `cdbdump` prints the contents of a database
  in `cdbmake`-compatible format.

Latest release: [20251021](download.html).

## Author

[D. J. Bernstein](https://cr.yp.to/djb.html)

## More support for cdb

More packages saying that they provide tools for you to use cdb format
(and in some cases cdb64 format):

* [cdb64](https://github.com/pcarrier/cdb64)
  from Pierre Carrier:
  Tweak of cdb-0.75 to support cdb64.

* [cdb64-rs](https://github.com/ever0de/cdb64-rs)
  from Jiseok Choi:
  Rust implementation of cdb64,
  plus wrappers for C, Node.js, and Python.

* [CDB_File](https://metacpan.org/pod/CDB_File):
  from Tim Goodwin, Matt Sergeant, and Todd Rinaldo:
  Perl wrapper around cdb.

* [cdb-full](https://rubygems.org/gems/cdb-full/versions/0.6?locale=en)
  from Kazuteru Okahashi and Rich Lane:
  Ruby wrapper around cdb.

* [CDB::TinyCDB](https://metacpan.org/pod/CDB::TinyCDB)
  from Alex J. G. Burzyński:
  Perl wrapper around TinyCDB.

* [go-cdb-1](https://github.com/jbarham/cdb):
  from John Barham:
  Go implementation.

* [go-cdb-2](https://github.com/colinmarc/cdb)
  from Colin Marc:
  Go implementation.

* [go-cdb64](https://pkg.go.dev/github.com/chrislusf/cdb64)
  from Chris Lu:
  Go implementation of cdb64.

* [howerj-cdb](https://github.com/howerj/cdb)
  from Richard James Howe:
  C implementation.

* [hs-cdb](https://hackage.haskell.org/package/hs-cdb)
  from Adam Smith:
  Haskell implementation.

* [libowfat](https://www.fefe.de/libowfat/):
  C implementation from Felix von Leitner (as part of a broader library).

* luacdb from Taj Khattra:
  Lua wrapper around cdb.

* [lua-tinycdb](https://github.com/asb/lua-tinycdb)
  from A. S. Bradbury:
  Lua wrapper around TinyCDB.

* [php-cdb](https://gerrit.wikimedia.org/g/cdb/):
  PHP implementation.

* [pure-cdb](https://hackage.haskell.org/package/pure-cdb)
  from Boris Sukholitko:
  Haskell implementation.

* [pycdb](https://www.unixuser.org/~euske/doc/cdbinternals/pycdb.py.html)
  from Yusuke Shinyama:
  Python implementation.

* [python-cdb](https://github.com/acg/python-cdb)
  from Mike Pomraning and Alan Grow:
  Python wrapper around cdb.

* [python-pure-cdb](https://python-pure-cdb.readthedocs.io/en/latest/)
  from David Wilson:
  Python implementation.
  Also supports cdb64.

* [rust-cdb](https://crates.io/crates/cdb)
  from Bruce Guenter:
  Rust implementation.

* [sg-cdb](https://www.strangegizmo.com/products/sg-cdb/)
  from Michael Alyn Miller:
  Java implementation.

* [swift-cdb](https://swiftpackageindex.com/aisk/swift-cdb):
  Swift wrapper around howerj-cdb.

* [TinyCDB](https://www.corpit.ru/mjt/tinycdb.html)
  from Michael Tokarev:
  C implementation.

Examples of applications using cdb format:
[djbdns](https://cr.yp.to/djbdns.html).
[dnsdist](https://www.dnsdist.org/index.html).
[Exim](https://www.exim.org/exim-html-3.10/doc/html/spec_2.html).
[fastforward](https://cr.yp.to/fastforward.html).
[krb5-strength](https://github.com/rra/krb5-strength).
[mess822](https://cr.yp.to/mess822.html).
[Postfix](https://www.postfix.org/CDB_README.html).
[qconfirm](https://smarden.org/qconfirm/cdb).
[qmail](https://cr.yp.to/qmail.html).
[ucspi-tcp](https://cr.yp.to/ucspi-tcp.html).
Examples of comparative benchmarks:
[2002](https://www.perlmonks.org/?node_id=152749).
[2004](https://web.archive.org/web/20040423185201/http://qdbm.sourceforge.net:80/benchmark.pdf).
[2008](https://dbmx.net/tokyocabinet/benchmark.pdf).
[2009](https://www.dmo.ca/blog/benchmarking-hash-databases-on-large-data/).
[2014](https://gist.github.com/epitron/1625d93d0b82c32e7395).
[2016](https://www.programmer.ie/post/acdb/).

Another spinoff of cdb allowing constant databases beyond 4GB is
Spotify's [sparkey](https://engineering.atspotify.com/2013/9/sparkey).
