### NAME

cdbtest - check a constant database

### SYNOPSIS

`cdbtest`

### DESCRIPTION

`cdbtest` reads a (seekable) constant database
from its standard input.
For each record in the database,
it double-checks that the record can be found by its key.
It prints tallies in several categories:

* `found` is the number of records
  found correctly by their keys.

* `different record` is the number of records
  where a different record was found with the same key.
  This should not happen unless the database has multiple records
  with the same key.

* `bad length` is the number of records
  found but with the wrong data length.
  This should never happen.

* `not found` is the number of records not found.
  This should never happen.

* `untested` is the number of records
  with keys longer than 1024 bytes.
  `cdbtest` doesn't bother testing these records.

There is also a `cdb64test` that uses cdb64 format instead of cdb format.

### SEE ALSO

**cdbget**(1),
**cdbmake**(1),
**cdbstats**(1)
