### NAME

cdbget - search for a record in a constant database

### SYNOPSIS

`cdbget` _K_

`cdbget` _K_ _S_

### DESCRIPTION

`cdbget` searches for a record with key _K_
in a constant database.
The constant database must be readable (and seekable)
on `cdbget`'s standard input.

`cdbget` prints the data
in the first record with key _K_ and exits 0.
If there is no record with key _K_,
`cdbget` exits 100 without printing anything.

If `cdbget` encounters a
read error, write error, or database format error,
it complains and exits 111.

If a numeric argument _S_ is provided,
`cdbget` skips past the first _S_ records with key _K_,
and prints the data in the next record.
For example, `cdbget foo 3` prints the fourth record with key `foo`
(skipping 3 records).

There is also a `cdb64get` that uses cdb64 format instead of cdb format.

### SEE ALSO

**cdbmake**(1),
**cdbdump**(1),
**cdbstats**(1)
