#include <unistd.h>
#include <string.h>
#include "inbuf.h"
#include "outbuf.h"
#include "strerr.h"
#include "seek.h"
#include "cdb.h"

#ifdef CDB64
#define FATAL "cdb64test: fatal: "
#else
#define FATAL "cdbtest: fatal: "
#endif

static void die_read(void)
{
  strerr_die2sys(111,FATAL,"unable to read input: ");
}
static void die_write(void)
{
  strerr_die2sys(111,FATAL,"unable to write output: ");
}
static void put(char *buf,num len)
{
  if (outbuf_put(outbuf_1small,buf,len) == -1) die_write();
}
static void putflush(void)
{
  if (outbuf_flush(outbuf_1small) == -1) die_write();
}

static num pos = 0;

static void get(char *buf,num len)
{
  num r;
  while (len > 0) {
    r = inbuf_get(inbuf_0,buf,len);
    if (r == -1) die_read();
    if (r == 0)
      strerr_die2x(111,FATAL,"unable to read input: truncated file");
    pos += r;
    buf += r;
    len -= r;
  }
}

static num getnum(void)
{
  char buf[CDB_NUMBYTES];
  num result;
  get(buf,CDB_NUMBYTES);
  result = cdb_unpacknum(buf);
  if (result < 0 || result > CDB_LIMIT)
    strerr_die2x(111,FATAL,"unable to read input: malformatted file");
  return result;
}

static char strnum[NUM_TOSTRING_NONNEG];

static void putnum(char *label,num count)
{
  put(label,strlen(label));
  put(strnum,num_tostring_nonneg(strnum,count));
  put("\n",1);
}

static char key[1024];

static num numuntested = 0;
static num numnotfound = 0;
static num numotherpos = 0;
static num numbadlen = 0;
static num numfound = 0;

static struct cdb c;

int main(int argc,char **argv)
{
  num eod;
  num klen;
  num dlen;
  num rest;

  cdb_init(&c,0);

  eod = getnum();
  while (pos < 256*2*CDB_NUMBYTES) dlen = getnum();

  while (pos < eod) {
    klen = getnum();
    dlen = getnum();
    if (klen > sizeof key) {
      ++numuntested;
      while (klen) { get(key,1); --klen; }
    }
    else {
      get(key,klen);
      rest = seek_cur(0);
      switch(cdb_find(&c,key,klen)) {
	case -1:
	  die_read();
	case 0:
	  ++numnotfound;
	  break;
	default:
	  if (cdb_datapos(&c) != pos)
	    ++numotherpos;
	  else
	    if (cdb_datalen(&c) != dlen)
	      ++numbadlen;
	    else
	      ++numfound;
      }
      if (seek_set(0,rest) == -1) die_read();
    }
    while (dlen) { get(key,1); --dlen; }
  }
  
  putnum("found: ",numfound);
  putnum("different record: ",numotherpos);
  putnum("bad length: ",numbadlen);
  putnum("not found: ",numnotfound);
  putnum("untested: ",numuntested);
  putflush();
  _exit(0);
  return 0;
}
