/* ccgo: walk.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "walk.hh"
using namespace go;

Walk::Walk(Node * n)
{
	pos = n;
	num = 0;
	if (n == NULL) return;
	Node * p = pos;
	while (p->get_prev() != NULL) {
		p = p->get_prev();
		num ++;
	}
}

Walk::Walk(const Walk & w)
{
	pos = w.pos;
	num = w.num;
}

Walk::~Walk()
{
	// std::cerr << "deleting Walk" << std::endl;
}

Node * Walk::get_pos()
{
	return pos;
}

bool Walk::up()
{
	if (pos == NULL) return false;
	if (pos->get_prev() == NULL) return false;
	pos = pos->get_prev();
	num --;
	return true;
}

unsigned Walk::n_down() const
{
	if (pos == NULL) return 0;
	return pos->get_link_size();
}

bool Walk::down(unsigned i)
{
	if (pos == NULL) return false;
	if (pos->get_link_size() <= i) return false;
	pos = pos->get_next(i);
	num ++;
	return true;
}

unsigned Walk::n_hop() const
{
	if (pos == NULL) return 0;
	if (pos->get_prev() == NULL) return 0;
	return pos->get_prev()->get_link_size();
}

void Walk::hop(unsigned i)
{
	up();
	down(i);
}

unsigned Walk::n()
{
	return pos->get_order();
}

unsigned Walk::pos_num() const
{
	return num;
}

bool Walk::operator== (const Walk & w) const
{
	return pos == w.pos;
}

bool Walk::operator!= (const Walk & w) const
{
	return pos != w.pos;
}
