/* ccgo: view_walk.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "view_walk.hh"
#include "proper_node.hh"
#include <sstream>
using namespace go;

ViewWalk::ViewWalk(Node * n) :
	Walk(n),
	Game(),
	GameWalk(n),
	ViewGame()
{
}

ViewWalk::~ViewWalk()
{
	// std::cerr << "deleting ViewWalk" << std::endl;
}

bool ViewWalk::up()
{
	return GameWalk::up();
}

bool ViewWalk::down(unsigned i)
{
	return GameWalk::down(i);
}

void ViewWalk::update_proper()
{
	clear_proper();
	ProperNode * pn = dynamic_cast<ProperNode *>(pos);
	if (pn == NULL || pn->get_proper() == NULL) return;
	set_proper(* pn->get_proper());
}
