/* ccgo: view_game.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef VIEW_GAME_HH
#define VIEW_GAME_HH
#include "game.hh"
#include <gtkmm/drawingarea.h>
namespace go {
	class ViewGame :
		virtual public Game,
		virtual public Gtk::DrawingArea
	{
		void on_realize();
		void on_unrealize();
		bool on_configure_event(GdkEventConfigure *);
		bool on_expose_event(GdkEventExpose *);
		void on_style_changed(const Glib::RefPtr<Gtk::Style> &);

		void do_width_height();

		bool use_bg_pixmap;
		Glib::RefPtr<Gdk::Pixmap> board_pixmap;

		bool stone_image_ok;
		Glib::RefPtr<Gdk::Pixbuf> w_stone_image;
		Glib::RefPtr<Gdk::Pixbuf> b_stone_image;

		bool scaled_ok;
		Glib::RefPtr<Gdk::Pixbuf> scaled_w_stone;
		Glib::RefPtr<Gdk::Pixbuf> scaled_b_stone;

		bool coordinate_on;
	protected:
		Glib::RefPtr<Gdk::Window> win;
		Glib::RefPtr<Gtk::Style> style;
		int win_w;
		int win_h;
		int cell_w;
		int cell_h;
		int pad_w;
		int pad_h;
		virtual void draw_loc_at(const Loc &, int, int);
		void draw_site(int, int);
		void draw_loc(const Loc &);
		void trans_loc(const Loc &, int &, int &);
		Loc find_loc(int, int);
	public:
		ViewGame();
		virtual ~ViewGame();
		virtual void set_board_size(unsigned);
		virtual void set_ko(const Loc &);
		virtual void set_last_move(const Loc &);
		virtual void set_site(const Loc &, State);
	};
}
#endif // VIEW_GAME_HH
