/* ccgo: ui/map.hh
 *
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#ifndef UI_MAP_HH
#define UI_MAP_HH
#include <go/node.hh>
namespace ui
{
	class Editor;

	class Map // graphic representation of a PathWalk on the Game tree
	{
		Editor * editor;
	protected:
		// for children information
		go::Node * where();
		unsigned path_max_level();
		go::Node * path(unsigned level);

		// for child override
		virtual void do_update();
	public:
		Map();
		virtual ~Map();
		void set_editor(Editor * ed);
		void update(); // update the map
	};
}
#endif // UI_MAP_HH
