/* ccgo: ui/map.cc
 * 
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#include <ui/map.hh>
#include <ui/editor.hh>
#include <go/game.hh>
#include <debug.hh>
#include <iostream>
#include <sstream>
using namespace ui;
using namespace go;
using namespace std;

Node * Map::where()
{
	assert(editor);
	return editor->where();
}

unsigned Map::path_max_level()
{
	assert(editor);
	return editor->get_depth();
}

Node * Map::path(unsigned level)
{
	assert(editor);
	if (level == 0) return editor->where()->get_game();
	assert(level <= editor->get_depth());
	return editor->get_path(level - 1);
}

void Map::do_update()
{
}

Map::Map() :
	editor(0)
{
}

Map::~Map()
{
}

void Map::set_editor(Editor * ed)
{
	editor = ed;
}

void Map::update()
{
	do_update();
}
