/* ccgo: ui/face.hh
 *
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#ifndef UI_FACE_HH
#define UI_FACE_HH
#include <go/board.hh>
#include <string>
namespace ui
{
	class Editor;

	class Face :
		public go::Board
	{
		Editor * editor;

		// overriding function
		void new_size(); // children should not override this one
	protected:
		enum Mode {
			VIEW_MODE, // return select on all sites
			EDIT_MODE, // no returns, board is to be changed
			MOVE_MODE, // return select on valid move sites
			PICK_MODE  // return select on stones
		};
		Mode get_mode() const;

		// used by children to notify Editor
		void play_move(go::Loc loc); // to play a move
		void pick_stone(go::Loc loc); // to pick a stone
		void knock_site(go::Loc loc); // to change properties of a site
		void track(go::Loc loc);

		// for children override
		virtual void new_face_size();
		virtual void new_mode();
		virtual void new_move_from(go::Move old);
		virtual void new_ko_from(const std::set<go::Loc> & old);
		virtual void new_mark(go::Loc loc);
		virtual void new_label(go::Loc loc);
	private:
		Mode mode;

		go::Turn turn; // stone to be placed in MOVE_MODE
		// for optional marking (last move and ko)
		go::Move mv;
		std::set<go::Loc> ko;
		go::Mark * mk;
		std::string * lb;
	public:
		Face();
		virtual ~Face();
		void copy_face(const Face & face);

		// should only be called by an editor
		void set_editor(Editor * ed);
		void set_turn(go::Turn t);
		void set_move(go::Move m);
		void set_ko(const std::set<go::Loc> & k);

		// marking
		void set_mark(go::Loc loc, go::Mark mark);
		go::Mark get_mark(go::Loc loc);
		void clear_marks();

		// labelling
		void set_label(go::Loc loc, const std::string & label);
		const std::string & get_label(go::Loc loc);
		void clear_labels();

		// mode changing
		void view();
		void edit();
		void move();
		void pick();

		// queries
		go::Turn get_turn() const;
		go::Move get_move() const;
		const std::set<go::Loc> & get_ko() const;
		bool loc_is_ko(go::Loc loc) const;
	};
}
#endif // UI_FACE_HH
