/* ccgo: ui/face.cc
 * 
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#include <ui/face.hh>
#include <ui/editor.hh>
#include <debug.hh>
#include <sstream>
using namespace ui;
using namespace go;
using namespace std;

void Face::new_size()
{
	if (mk) delete [] mk;
	mk = new Mark [range()];
	for (Loc l = 0; l < range(); l ++) mk[l] = MARK_NONE;
	if (lb) delete [] lb;
	lb = new string [range()];
	new_face_size();
}

Face::Mode Face::get_mode() const
{
	return mode;
}

void Face::play_move(Loc loc)
{
	assert(! state(loc));
	if (editor) editor->face_play(loc);
}

void Face::pick_stone(Loc loc)
{
	assert(state(loc));
	if (editor) editor->face_pick(loc);
}

void Face::knock_site(Loc loc)
{
	if (editor) editor->face_knock(loc);
}

void Face::track(Loc loc)
{
	if (editor) editor->face_track(loc);
}

void Face::new_face_size()
{
}

void Face::new_mode()
{
}

void Face::new_move_from(Move old)
{
}

void Face::new_ko_from(const set<Loc> & old)
{
}

void Face::new_mark(Loc loc)
{
}

void Face::new_label(Loc loc)
{
}

Face::Face() :
	editor(0),
	mode(VIEW_MODE),
	turn(Black),
	mv(MoveNone)
{
	if (get_size()) {
		mk = new Mark [range()];
		for (Loc l = 0; l < range(); l ++) mk[l] = MARK_NONE;
		lb = new string [range()];
	}
	else {
		mk = 0;
		lb = 0;
	}
}

Face::~Face()
{
	if (mk) delete [] mk;
	if (lb) delete [] lb;
}

void Face::copy_face(const Face & face)
{
	set_editor(face.editor);
	set_turn(face.turn);
	set_move(face.mv);
	set_ko(face.ko);
	clear_marks();
	clear_labels();
	for (Loc l = 0; l < range(); l ++) {
		set_mark(l, face.mk[l]);
		set_label(l, face.lb[l]);
	}
	if (mode != face.mode) {
		mode = face.mode;
		new_mode();
	}
}

void Face::set_editor(Editor * ed)
{
	editor = ed;
}

void Face::set_turn(Turn t)
{
	turn = t; // different turn, need to change cursor
}

void Face::set_move(Move m)
{
	if (mv == m) return;
	Move old = mv;
	mv = m;
	new_move_from(old);
}

void Face::set_ko(const set<Loc> & k)
{
	if (ko == k) return;
	set<Loc> old = ko;
	ko = k;
	new_ko_from(old);
}

void Face::set_mark(Loc loc, Mark mark)
{
	if (mk[loc] == mark) return;
	mk[loc] = mark;
	new_mark(loc);
	// view_site(loc);
}

Mark Face::get_mark(Loc loc)
{
	assert(loc < range());
	return mk[loc];
}

void Face::clear_marks()
{
	for (Loc l = 0; l < range(); l ++) if (mk[l] != MARK_NONE) {
		mk[l] = MARK_NONE;
		new_mark(l);
	}
}

void Face::set_label(Loc loc, const string & label)
{
	if (lb[loc] == label) return;
	lb[loc] = label;
	new_label(loc);
}

const string & Face::get_label(Loc loc)
{
	assert(loc < range());
	return lb[loc];
}

void Face::clear_labels()
{
	for (Loc l = 0; l < range(); l ++) if (lb[l].size()) {
		lb[l].clear();
		new_label(l);
	}
}

void Face::view()
{
	if (mode == VIEW_MODE) return;
	mode = VIEW_MODE;
	new_mode();
}

void Face::edit()
{
	if (mode == EDIT_MODE) return;
	mode = EDIT_MODE;
	new_mode();
}

void Face::move()
{
	if (mode == MOVE_MODE) return;
	mode = MOVE_MODE;
	new_mode();
}

void Face::pick()
{
	if (mode == PICK_MODE) return;
	mode = PICK_MODE;
	new_mode();
}

Turn Face::get_turn() const
{
	return turn;
}

Move Face::get_move() const
{
	return mv;
}

const set<Loc> & Face::get_ko() const
{
	return ko;
}

bool Face::loc_is_ko(Loc loc) const
{
	return ko.find(loc) != ko.end();
}
