/* ccgo: ui/editor.hh
 *
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#ifndef UI_EDITOR_HH
#define UI_EDITOR_HH
#include <go/path_walk.hh>
#include <ui/face.hh>
#include <ui/map.hh>
namespace ui
{
	class Editor :
		private go::PathWalk
	{
	private:
		bool is_movable() const;
		void new_size();
		void new_state(go::Loc loc);
		void moved_from(go::Node * old);
		void new_path();

		Face * face;
		Map * map;

		enum Mode {
			NORMAL_MODE, // play, marking (where() != 0), init (where() == 0)
			SETUP_MODE, // changing the board
			SCORE_MODE // scoring (a specialized MARK_MODE)
		};
		Mode mode;
		bool attached;

		friend class Face;
		// notification by Face
		void face_play(go::Loc loc); // call by face for return site in play
		void face_pick(go::Loc loc); // call by face to pick a stone
		void face_knock(go::Loc loc); // call by face to change properties of a site
		void face_track(go::Loc loc); // call by face when tracking changes
		friend class Map;

		// for scoring
		go::State * terri;
		unsigned bscore; // b territory + zombie w
		unsigned wscore; // w territory + zombie b
		void scoring_update();
		void markup_face(); // update marks and labels on face
 	protected:
		// for children override
		virtual void view_site(go::Loc loc); // should display info about the site
		virtual void new_node(); // moved to a new node
		virtual void change_site(go::Loc loc, go::Mark & mk, std::string & lb); // change properties at loc
	public:
		Editor();
		virtual ~Editor();
		void set_face(Face * f);
		void set_map(Map * m);
		void set_node(go::Node * node);
	protected:
		// user interface for children
		// basic movement
		void attach(go::Node * node);
		void down();
		void up();
		void hop();
		void hop(unsigned alt);

		// special modes
		void setup();
		void score();
		void done_setup();
		void done_score();
		void cancel_setup();
		void cancel_score();

		// initialize game
		bool can_init(); // only when node == NULL and face != NULL
		void init_size(unsigned sz);
		void init_handi(unsigned h);
		void init_board(const Board & board);
		void init_turn(go::Turn t);
		void init_create(); // create a new game

		// setup
		void setup_turn(go::Turn t);

		// action on game
		bool can_play() const;
		bool can_crawl() const;
		bool doing_setup() const;
		bool is_scoring() const;
		void pass();

		// properties of node
		bool is_attached();
		unsigned get_move_num();
		go::Turn get_turn();
		unsigned get_level();
		const std::string & get_text();
		void set_text(const std::string & text);
		unsigned get_alt_num(); // how many alternatives
		unsigned get_alt(); // which alternative this node is
		double get_b_score();
		double get_w_score();

		// deleting node
		bool can_del_node();
		void del_node();
	};
}
#endif // UI_EDITOR_HH
