/* ccgo: time.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef TIME_HH
#define TIME_HH
// #include <sigc++/object.h>
#include "go.hh"
#include <gtkmm/box.h>
#include <gtkmm/label.h>
#include <sigc++/signal.h>
namespace go
{
	class Time :
		public Gtk::VBox
	{
		int time;
		int byo_time;
		int byo_move;
		int w_time;
		int b_time;
		int w_move;
		int b_move;
		Turn turn;
		long mark_sec;
		long mark_usec;
		void mark_time();
		long get_time();
		long tick_time;
		bool tick();
		bool run;
		Gtk::Label b_timing;
		Gtk::Label w_timing;
		void update_timing();
		sigc::connection time_con;
		unsigned counter;
		void adjust_sizes();
		void on_realize();
		void on_style_changed(const Glib::RefPtr<Gtk::Style> &);
	public:
		Time();
		~Time();
		
		void setup(int, int, int);
		void calibrate(int, int, int, int);
		void start();
		void stop();
		void toggle();
		unsigned get_counter();

		sigc::signal<void, Turn> timeup;
	};
}
#endif // TIME_HH
