/* ccgo: setup.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef SETUP_HH
#define SETUP_HH
#include "game.hh"
#include "modifi.hh"
#include <vector>
namespace go {
	class Setup :
		virtual public Modifi
	{
	public:
		class Site
		{
		public:
			Site(const Loc &, State);
			Loc loc;
			State state;
		};
	private:
		std::vector<Site> pre_state ;
		std::vector<Site> state;
		Turn pre_turn;
		Turn turn;
		Loc pre_ko;
		Loc pre_last_move;
	public:
		Setup(const std::vector<Site> &, Turn);
		Setup(const Setup &);
		virtual ~Setup();
		virtual Modifi * dup() const;
		virtual void check(const Game &);
		virtual void apply(Game &) const;
		virtual void undo(Game &) const;
	};
}
#endif // SETUP_HH
