/* ccgo: setup.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "setup.hh"

using namespace go;

Setup::Site::Site(const Loc & l, State s)
{
	loc = l;
	state = s;
}

Setup::Setup(const std::vector<Site> & s, Turn t)
{
	state = s;
	turn = t;
}

Setup::Setup(const Setup & s)
{
	pre_state = s.pre_state;
	state = s.state;
	pre_turn = s.pre_turn;
	turn = s.turn;
	pre_ko = s.pre_ko;
	pre_last_move = s.pre_last_move;
}

Setup::~Setup()
{
}

Modifi * Setup::dup() const
{
	return new Setup(* this);
}

void Setup::check(const Game & g)
{
	pre_state.clear();
	for (std::vector<Site>::iterator i = state.begin(); i != state.end(); i ++) pre_state.push_back(Site(i->loc, g.get_site(i->loc)));
	pre_turn = g.get_turn();
	pre_ko = g.get_ko();
	pre_last_move = g.get_last_move();
}

void Setup::apply(Game & g) const
{
	for (std::vector<Site>::const_iterator i = state.begin(); i != state.end(); i ++) g.set_site(i->loc, i->state);
	g.set_turn(turn);
	g.set_ko(Loc());
	g.set_last_move(Loc());
}

void Setup::undo(Game & g) const
{
	for (std::vector<Site>::const_iterator i = pre_state.begin(); i != pre_state.end(); i ++) g.set_site(i->loc, i->state);
	g.set_turn(pre_turn);
	g.set_ko(pre_ko);
	g.set_last_move(pre_last_move);
}
