/* ccgo: settings.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef SETTING_WIN_HH
#define SETTING_WIN_HH
#include "settings.hh"
#include <gtkmm/dialog.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/entry.h>
#include <gtkmm/adjustment.h>

namespace go
{
	class SettingWin :
		public Gtk::Dialog
	{
		enum Response {
			RE_CLEAR,
			RE_CLOSE
		};
		void on_response(int);

		void toggle_option(Gtk::CheckButton *, Settings::Options);

		Gtk::Entry  image_path_entry;
		void set_image_path();

		void toggle_igs_direct(Gtk::CheckButton *);


		Gtk::HBox * hb_igs_direct0;
		Gtk::Entry  igs_telnet_entry;
		void set_igs_telnet();

		
		Gtk::HBox * hb_igs_direct1;
		Gtk::Entry igs_host_entry;
		void set_igs_host();
		Gtk::Adjustment * igs_port_adj;
		void set_igs_port();
	public:
		SettingWin();
		~SettingWin();
		sigc::signal<void> reset;
	};
}
#endif // SETTING_WIN_HH
