/* ccgo: setting_win.cc
 *
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#include "config.hh"
#include "gettext.h"
#include "setting_win.hh"
#include <gconfmm/init.h>
#include <gtkmm/stock.h>
#include <gtkmm/label.h>
#include <gtkmm/spinbutton.h>
#define _(String) Glib::locale_to_utf8(gettext(String))

using namespace go;

void SettingWin::on_response(int r)
{
	switch ((Response) r) {
	case RE_CLEAR:
		// hide();
		reset(); // this will delete myself
		break;
	case RE_CLOSE:
		hide();
		break;
	}
}

void SettingWin::toggle_option(Gtk::CheckButton * cb, Settings::Options o)
{
	settings.set_option(o, cb->get_active());
}

void SettingWin::set_image_path()
{
	settings.set_image_path(image_path_entry.get_text());
}

void SettingWin::toggle_igs_direct(Gtk::CheckButton * cb)
{
	settings.set_option(Settings::OPT_IGS_DIRECT, cb->get_active());
	hb_igs_direct0->set_sensitive(! cb->get_active());
	hb_igs_direct1->set_sensitive(cb->get_active());
}

void SettingWin::set_igs_telnet()
{
	settings.set_igs_telnet(igs_telnet_entry.get_text());
}

void SettingWin::set_igs_host()
{
	settings.set_igs_host(igs_host_entry.get_text());
}

void SettingWin::set_igs_port()
{
	settings.set_igs_port(unsigned(igs_port_adj->get_value()));
}

SettingWin::SettingWin() :
	igs_port_adj(Gtk::manage(new Gtk::Adjustment(0, 0, 65535)))
{
	set_title(_("ccGo properties"));

	get_vbox()->pack_start(* Gtk::manage(new Gtk::Label(_("Property Settings"))));

	Gtk::HBox * hb;
	Gtk::CheckButton * cb;

	hb = Gtk::manage(new Gtk::HBox);
	get_vbox()->pack_start(* hb, Gtk::PACK_SHRINK);
	cb = Gtk::manage(new Gtk::CheckButton(_("Dump all communications with IGS to stdout")));
	cb->set_active(settings.get_option(Settings::OPT_DUMP_IGS));
	hb->pack_start(* cb, Gtk::PACK_SHRINK);
	cb->signal_toggled().connect(bind(mem_fun(* this, & SettingWin::toggle_option), cb, Settings::OPT_DUMP_IGS));

	hb = Gtk::manage(new Gtk::HBox);
	get_vbox()->pack_start(* hb, Gtk::PACK_SHRINK);
	cb = Gtk::manage(new Gtk::CheckButton(_("Show unprocessed messages from IGS")));
	cb->set_active(settings.get_option(Settings::OPT_LEAK_RAW));
	hb->pack_start(* cb, Gtk::PACK_SHRINK);
	cb->signal_toggled().connect(bind(mem_fun(* this, & SettingWin::toggle_option), cb, Settings::OPT_LEAK_RAW));

	hb = Gtk::manage(new Gtk::HBox);
	get_vbox()->pack_start(* hb, Gtk::PACK_SHRINK);
	cb = Gtk::manage(new Gtk::CheckButton(_("Client-side time control")));
	cb->set_active(settings.get_option(Settings::OPT_CLIENT_TIME_CONTROL));
	hb->pack_start(* cb, Gtk::PACK_SHRINK);
	cb->signal_toggled().connect(bind(mem_fun(* this, & SettingWin::toggle_option), cb, Settings::OPT_CLIENT_TIME_CONTROL));

	hb = Gtk::manage(new Gtk::HBox);
	get_vbox()->pack_start(* hb, Gtk::PACK_SHRINK);
	cb = Gtk::manage(new Gtk::CheckButton(_("Popup Player List on tell message")));
	cb->set_active(settings.get_option(Settings::OPT_POP_PLAYERS_ON_TELL));
	hb->pack_start(* cb, Gtk::PACK_SHRINK);
	cb->signal_toggled().connect(bind(mem_fun(* this, & SettingWin::toggle_option), cb, Settings::OPT_POP_PLAYERS_ON_TELL));

	hb = Gtk::manage(new Gtk::HBox);
	get_vbox()->pack_start(* hb, Gtk::PACK_SHRINK);
	cb = Gtk::manage(new Gtk::CheckButton(_("Popup Player List on stats message")));
	cb->set_active(settings.get_option(Settings::OPT_POP_PLAYERS_ON_STATS));
	hb->pack_start(* cb, Gtk::PACK_SHRINK);
	cb->signal_toggled().connect(bind(mem_fun(* this, & SettingWin::toggle_option), cb, Settings::OPT_POP_PLAYERS_ON_STATS));

	hb = Gtk::manage(new Gtk::HBox);
	get_vbox()->pack_start(* hb, Gtk::PACK_SHRINK);
	cb = Gtk::manage(new Gtk::CheckButton(_("Popup Player List on match request")));
	cb->set_active(settings.get_option(Settings::OPT_POP_PLAYERS_ON_MATCH));
	hb->pack_start(* cb, Gtk::PACK_SHRINK);
	cb->signal_toggled().connect(bind(mem_fun(* this, & SettingWin::toggle_option), cb, Settings::OPT_POP_PLAYERS_ON_MATCH));

	hb = Gtk::manage(new Gtk::HBox);
	get_vbox()->pack_start(* hb, Gtk::PACK_SHRINK);
	cb = Gtk::manage(new Gtk::CheckButton(_("Fetch player stats on player popup")));
	cb->set_active(settings.get_option(Settings::OPT_GET_STATS_ON_POP));
	hb->pack_start(* cb, Gtk::PACK_SHRINK);
	cb->signal_toggled().connect(bind(mem_fun(* this, & SettingWin::toggle_option), cb, Settings::OPT_GET_STATS_ON_POP));

	hb = Gtk::manage(new Gtk::HBox);
	get_vbox()->pack_start(* hb, Gtk::PACK_SHRINK);
	cb = Gtk::manage(new Gtk::CheckButton(_("Show coordinates beside the board")));
	cb->set_active(settings.get_option(Settings::OPT_SHOW_COORDINATE));
	hb->pack_start(* cb, Gtk::PACK_SHRINK);
	cb->signal_toggled().connect(bind(mem_fun(* this, & SettingWin::toggle_option), cb, Settings::OPT_SHOW_COORDINATE));

	hb = Gtk::manage(new Gtk::HBox);
	get_vbox()->pack_start(* hb, Gtk::PACK_SHRINK);
	cb = Gtk::manage(new Gtk::CheckButton(_("Use picture stone images")));
	cb->set_active(settings.get_option(Settings::OPT_PICTURE_STONE));
	hb->pack_start(* cb, Gtk::PACK_SHRINK);
	cb->signal_toggled().connect(bind(mem_fun(* this, & SettingWin::toggle_option), cb, Settings::OPT_PICTURE_STONE));

	hb = Gtk::manage(new Gtk::HBox);
	get_vbox()->pack_start(* hb, Gtk::PACK_SHRINK);
	cb = Gtk::manage(new Gtk::CheckButton(_("Use picture board image")));
	cb->set_active(settings.get_option(Settings::OPT_PICTURE_BOARD));
	hb->pack_start(* cb, Gtk::PACK_SHRINK);
	cb->signal_toggled().connect(bind(mem_fun(* this, & SettingWin::toggle_option), cb, Settings::OPT_PICTURE_BOARD));

	hb = Gtk::manage(new Gtk::HBox);
	get_vbox()->pack_start(* hb, Gtk::PACK_SHRINK);
	hb->pack_start(* Gtk::manage(new Gtk::Label(_("Path to image files:") + " ")), Gtk::PACK_SHRINK);
	hb->pack_end(image_path_entry);
	image_path_entry.set_text(settings.get_image_path());
	image_path_entry.signal_changed().connect(mem_fun(* this, & SettingWin::set_image_path));

	hb = Gtk::manage(new Gtk::HBox);
	get_vbox()->pack_start(* hb, Gtk::PACK_SHRINK);
	cb = Gtk::manage(new Gtk::CheckButton(_("Direct connection to IGS server")));
	cb->set_active(settings.get_option(Settings::OPT_IGS_DIRECT));
	hb->pack_start(* cb, Gtk::PACK_SHRINK);
	cb->signal_toggled().connect(bind(mem_fun(* this, & SettingWin::toggle_igs_direct), cb));

	hb = Gtk::manage(new Gtk::HBox);
	get_vbox()->pack_start(* hb, Gtk::PACK_SHRINK);
	hb->pack_start(* Gtk::manage(new Gtk::Label(_("IGS telnet command:") + " ")), Gtk::PACK_SHRINK);
	hb->pack_end(igs_telnet_entry);
	igs_telnet_entry.set_text(settings.get_igs_telnet());
	igs_telnet_entry.signal_changed().connect(mem_fun(* this, & SettingWin::set_igs_telnet));
	hb_igs_direct0 = hb;
	hb->set_sensitive(! settings.get_option(Settings::OPT_IGS_DIRECT));

	hb = Gtk::manage(new Gtk::HBox);
	get_vbox()->pack_start(* hb, Gtk::PACK_SHRINK);
	hb->pack_start(* Gtk::manage(new Gtk::Label(_("IGS host:") + " ")), Gtk::PACK_SHRINK);
	hb->pack_start(igs_host_entry);
	igs_host_entry.set_text(settings.get_igs_host());
	igs_host_entry.signal_changed().connect(mem_fun(* this, & SettingWin::set_igs_host));

	Gtk::SpinButton * sb = Gtk::manage(new Gtk::SpinButton(* igs_port_adj));
	hb->pack_start(* Gtk::manage(new Gtk::Label(std::string("  ") + _("port:") + " ")), Gtk::PACK_SHRINK);
	hb->pack_end(* sb, Gtk::PACK_SHRINK);
	igs_port_adj->set_value(settings.get_igs_port());
	igs_port_adj->signal_value_changed().connect(mem_fun(* this, & SettingWin::set_igs_port));
	hb_igs_direct1 = hb;
	hb->set_sensitive(settings.get_option(Settings::OPT_IGS_DIRECT));

	add_button(Gtk::Stock::CLEAR, RE_CLEAR);
	add_button(Gtk::Stock::CLOSE, RE_CLOSE);
	show_all_children();
}

SettingWin::~SettingWin()
{
}
