/* ccgo: score_proper.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "score_proper.hh"

using namespace go;

ScoreProper::ScoreProper()
{
	board_size = 0;
	terri = 0;
}

ScoreProper::ScoreProper(const ScoreProper & p) :
	Proper(p)
{
	board_size = p.board_size;
	if (p.terri) {
		terri = new Terri[board_size * board_size];
		for (unsigned i = 0; i < board_size * board_size; i ++) terri[i] = p.terri[i];
	} else terri = 0;
	terri_score_w = p.terri_score_w;
	terri_score_b = p.terri_score_b;
}

ScoreProper::~ScoreProper()
{
	if (terri) delete[] terri;
}

Proper * ScoreProper::dup() const
{
	return new ScoreProper(* this);
}

void ScoreProper::set_terri(const Game & g, Terri * t)
{
	unsigned z = g.get_board_size();
	board_size = z;
	if (terri) delete terri;
	if (! t) {
		terri = 0;
		return;
	}
	terri = t;
	terri_score_w = 0;
	terri_score_b = 0;
	for (unsigned i = 0; i < z * z; i ++) if (terri[i]) {
		Loc l = Loc::distribute(z, i);
		get_marks().push_back(Proper::Marking(l, terri[i] == TERRI_WHITE ? MARK_W_TERRITORY : MARK_B_TERRITORY));
		State s = g.get_site(l);
		if (s == STATE_WHITE) terri_score_b ++;
		else if (s == STATE_BLACK) terri_score_w ++;
		if (terri[i] == TERRI_WHITE) terri_score_w ++;
		else terri_score_b ++;
	}
}

const Terri * ScoreProper::get_terri() const
{
	return terri;
}

unsigned ScoreProper::get_terri_score_w() const
{
	return terri_score_w;
}

unsigned ScoreProper::get_terri_score_b() const
{
	return terri_score_b;
}
