/* ccgo: root_proper.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef ROOT_PROPER_HH
#define ROOT_PROPER_HH
#include "proper.hh"
namespace go {
	class RootProper :
		virtual public Proper
	{
		unsigned size;
		double komi;
		unsigned handicap;
		std::string game_name;
		Board * init; // initial board configuration
	public:
		RootProper();
		RootProper(const RootProper &);
		virtual Proper * dup() const;
		// void build(const Game &, const sgf::Node &);
		void set_size(unsigned);
		unsigned get_size() const;
		void set_komi(double);
		double get_komi() const;
		void set_handicap(unsigned handicap);
		unsigned get_handicap() const;
		void set_game_name(const std::string &);
		const std::string & get_game_name() const;
		void set_init(const Board *);
		const Board * get_init() const;
	};
}
#endif // ROOT_PROPER_HH
