/* ccgo: root_proper.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "root_proper.hh"

using namespace go;

RootProper::RootProper() :
	init(0)
{
	size = 19;
	komi = 0;
	handicap = 0;
}

RootProper::RootProper(const RootProper & p) :
	Proper(p)
{
	size = p.size;
	komi = p.komi;
	handicap = p.handicap;
	game_name = p.game_name;
	init = p.init ? p.init->dup() : 0;
}

Proper * RootProper::dup() const
{
	return new RootProper(* this);
}

void RootProper::set_size(unsigned z)
{
	size = z;
}

unsigned RootProper::get_size() const
{
	return size;
}

void RootProper::set_komi(double k)
{
	komi = k;
}

double RootProper::get_komi() const
{
	return komi;
}

void RootProper::set_handicap(unsigned h)
{
	handicap = h;
}

unsigned RootProper::get_handicap() const
{
	return handicap;
}

void RootProper::set_game_name(const std::string & n)
{
	game_name = n;
}

const std::string & RootProper::get_game_name() const
{
	return game_name;
}

void RootProper::set_init(const Board * b)
{
	if (init) delete init;
	init = b->Board::dup();
}

const Board * RootProper::get_init() const
{
	return init;
}
