/* ccgo: put_move.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef PUT_MOVE_HH
#define PUT_MOVE_HH
#include "move.hh"
namespace go {
	class PutMove :
		public Move
	{
		// preset:
		Loc loc;
		// to check:
		std::vector<Loc> kill;
		bool ko;
	public:
		PutMove(Turn, const Loc &);
		PutMove(const PutMove &);
		Modifi * dup() const;
		bool check(const Game &);
		void apply(Game &) const;
		void undo(Game &) const;
		virtual std::string as_string() const;
	};
}
#endif // PUT_MOVE_HH
