/* ccgo: put_move.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "put_move.hh"
#include <sstream>

using namespace go;

PutMove::PutMove(Turn t, const Loc & l) :
	Move(t)
{
	loc = l;
}

PutMove::PutMove(const PutMove & m) :
	Move(m)
{
	loc = m.loc;
	kill = m.kill;
	ko = m.ko;
}

Modifi * PutMove::dup() const
{
	return new PutMove(* this);
}

bool PutMove::check(const Game & g)
{
	if (! Move::check(g)) return false;
	if (loc == Loc()) return checked  = false;
	if (! (g.check_space(loc) || g.get_rule().overlap_stone)) return checked = false;
	kill.clear();
	g.get_kill(loc, kill);
	ko = false;
	if (kill.size() == 1 && g.check_eye(loc)) {
		ko = true;
		return true;
	}
	if (kill.size() > 0) return true;
	if (g.check_fill(loc, kill) != 0) {
		kill.clear();
		return true;
	}
	if (g.get_rule().suicide_allowed) return true;
	kill.clear();
	return checked = false;
}

void PutMove::apply(Game & g) const
{
	if (! checked) return;
	Move::apply(g);
	g.set_site(loc, Board::stone(turn));
	if (kill.size() > 0) {
		if (ko) g.set_ko(* kill.begin());
		for (std::vector<Loc>::const_iterator i = kill.begin(); i != kill.end(); i ++) g.set_site(* i, STATE_EMPTY);
		Turn tc = (loc == * kill.begin() ? turn : flip(turn));
		if (tc == TURN_WHITE) g.set_cap_b(g.get_cap_b() + kill.size());
		else g.set_cap_w(g.get_cap_w() + kill.size());
	}
	g.set_last_move(loc);
}

void PutMove::undo(Game & g) const
{
	if (kill.size() > 0) {
		Turn tc = (loc == * kill.begin() ? turn : flip(turn));
		if (tc == TURN_WHITE) g.set_cap_b(g.get_cap_b() - kill.size());
		else g.set_cap_w(g.get_cap_w() - kill.size());
		State s = Board::stone(tc);
		for (std::vector<Loc>::const_iterator i = kill.begin(); i != kill.end(); ++ i) g.set_site(* i, s);
	}
	g.set_site(loc, STATE_EMPTY);
	Move::undo(g);
}

std::string PutMove::as_string() const
{
	std::ostringstream s;
	s << num << ". " << (turn == TURN_BLACK ? "B" : "W") << ": " << loc.to_string();
	return s.str();
}
