/* ccgo: proper_node.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "proper_node.hh"

using namespace go;
using namespace std;

Node * ProperNode::create_copy() const
{
	ProperNode * n = new ProperNode;
	if (proper) n->proper = proper->dup();
	return n;
}

ProperNode::ProperNode() :
	proper(0)
{
}

ProperNode::~ProperNode()
{
	if (proper) delete proper;
}

void ProperNode::set_proper(const Game & g, Proper * p)
{
	set_proper(p);
}

void ProperNode::set_proper(Proper * p)
{
	if (proper) delete proper;
	proper = p;
}

const Proper * ProperNode::get_proper() const
{
	return proper;
}

Proper * ProperNode::get_proper()
{
	return proper;
}
