/* ccgo: proper_game.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef PROPER_GAME_HH
#define PROPER_GAME_HH
#include "proper.hh"
#include "view_game.hh"
#include <gtkmm/textview.h>
#include <gtkmm/label.h>
namespace go
{
	class ProperGame :
		virtual public ViewGame
	{
	public:
	private:
		std::string * * label;
		Mark * mark;
		Loc track;
		Gtk::Label b_score_port;
		Gtk::Label w_score_port;
		Gtk::TextView text_port;
		Gtk::Label modifi_port;
		Gtk::Label label_port;
		bool on_enter_notify_event(GdkEventCrossing *);
		bool on_leave_notify_event(GdkEventCrossing *);
		bool on_motion_notify_event(GdkEventMotion *);
		int score_modify_w;
		int score_modify_b;
		void update_score();
	protected:
		virtual void draw_loc_at(const Loc &, int, int);
		virtual void on_track_change();
		const Loc & get_track() const;
	public:
		ProperGame();
		virtual ~ProperGame();
// 		void set_komi(double);
// 		void set_cap_w(unsigned);
// 		void set_cap_b(unsigned);
		virtual void set_board_size(unsigned);
		// const string * get_mark(const Loc &) const;
		void clear_proper();
		void set_proper(const Proper &);
		Gtk::Label & w_score_widget();
		Gtk::Label & b_score_widget();
		Gtk::TextView & text_widget();
		Gtk::Label & modifi_widget();
		Gtk::Label & label_widget();
	};
}
#endif // PROPER_GAME_HH
