/* ccgo: proper.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef PROPER_HH
#define PROPER_HH
// #include "sgf/node.hh"
#include "game.hh"
namespace go
{
	class Proper
	{
	public:
		struct Label
		{
			go::Loc loc;
			std::string label;
		};

		struct Marking
		{
			Loc loc;
			Mark mark;
			Marking(const Loc &, Mark);
		};
	private:
		std::string name;
		std::string comment;
		std::vector<Label> labels;
		std::vector<Marking> marks;
	public:
		Proper();
		Proper(const Proper &);
		virtual ~Proper();
		virtual Proper * dup() const;
		// virtual void build(const Game &, const sgf::Node &);
		const std::string & get_name() const;
		void set_name(const std::string &);
		const std::string & get_comment() const;
		void set_comment(const std::string &);
		const std::vector<Label> & get_labels() const;
		void set_labels(const std::vector<Label> &);
		const std::vector<Marking> & get_marks() const;
		std::vector<Marking> & get_marks();
		void set_marks(const std::vector<Marking> &);
	};
}
#endif // PROPER_HH
