/* ccgo: proper.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "proper.hh"

using namespace go;

Proper::Marking::Marking(const Loc & l, Mark m)
{
	loc = l;
	mark = m;
}

Proper::Proper()
{
}

Proper::Proper(const Proper & p)
{
	name = p.name;
	comment = p.name;
	labels = p.labels;
	marks = p.marks;
}

Proper::~Proper()
{
}

Proper * Proper::dup() const
{
	return new Proper(* this);
}

// void Proper::build(const Game & g, const sgf::Node & n)
// {
// 	const sgf::Prop * p;
// 	unsigned z = g.get_board_size();
// 	if ((p = n.find("N")) != NULL) name = p->as_string();
// 	else name = "";
// 	if ((p = n.find("C")) != NULL) comment = p->as_string();
// 	else comment = "";
// 	if ((p = n.find("LB")) != NULL) labels = p->ar_label(z);
// 	else labels.clear();
// 	marks.clear();
// 	if ((p = n.find("CR")) != NULL) {
// 		std::vector<Loc> l = p->ar_loc(z);
// 		for (std::vector<Loc>::const_iterator i = l.begin(); i != l.end(); i ++) marks.push_back(Marking(* i, MARK_CIRCLE));
// 	}
// 	if ((p = n.find("TR")) != NULL) {
// 		std::vector<Loc> l = p->ar_loc(z);
// 		for (std::vector<Loc>::const_iterator i = l.begin(); i != l.end(); i ++) marks.push_back(Marking(* i, MARK_TRIANGLE));
// 	}
// 	if ((p = n.find("SQ")) != NULL) {
// 		std::vector<Loc> l = p->ar_loc(z);
// 		for (std::vector<Loc>::const_iterator i = l.begin(); i != l.end(); i ++) marks.push_back(Marking(* i, MARK_SQUARE));
// 	}
// 	if ((p = n.find("MA")) != NULL) {
// 		std::vector<Loc> l = p->ar_loc(z);
// 		for (std::vector<Loc>::const_iterator i = l.begin(); i != l.end(); i ++) marks.push_back(Marking(* i, MARK_CROSS));
// 	}
// 	if ((p = n.find("SL")) != NULL) {
// 		std::vector<Loc> l = p->ar_loc(z);
// 		for (std::vector<Loc>::const_iterator i = l.begin(); i != l.end(); i ++) marks.push_back(Marking(* i, MARK_SELECT));
// 	}
// 	if ((p = n.find("TW")) != NULL) {
// 		std::vector<Loc> l = p->ar_loc(z);
// 		for (std::vector<Loc>::const_iterator i = l.begin(); i != l.end(); i ++) marks.push_back(Marking(* i, MARK_W_TERRITORY));
// 	}
// 	if ((p = n.find("TB")) != NULL) {
// 		std::vector<Loc> l = p->ar_loc(z);
// 		for (std::vector<Loc>::const_iterator i = l.begin(); i != l.end(); i ++) marks.push_back(Marking(* i, MARK_B_TERRITORY));
// 	}
// }

const std::string & Proper::get_name() const
{
	return name;
}

void Proper::set_name(const std::string & n)
{
	name = n;
}

const std::string & Proper::get_comment() const
{
	return comment;
}

void Proper::set_comment(const std::string & c)
{
	comment = c;
}

const std::vector<Proper::Label> & Proper::get_labels() const
{
	return labels;
}

void Proper::set_labels(const std::vector<Label> & l)
{
	labels = l;
}

const std::vector<Proper::Marking> & Proper::get_marks() const
{
	return marks;
}

std::vector<Proper::Marking> & Proper::get_marks()
{
	return marks;
}

void Proper::set_marks(const std::vector<Marking> & m)
{
	marks = m;
}
