/* ccgo: player.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef PLAYER_HH
#define PLAYER_HH
#include "arena.hh"
#include <sigc++/signal.h>
namespace go
{
	class Player
	{
	protected:
		Arena * arena;
		bool playing;
		bool scoring;
		void ask_terri(Terri *);
	public:
		Player();
		virtual ~Player();
		virtual void set_arena(Arena * arena);
		virtual void enable_player();
		virtual void disable_player();
		virtual void enter_scoring();
		virtual void done_scoring();
		virtual void notify_setup(const Board & board);
		virtual void notify_handicap(unsigned handicap);
		virtual void notify_put(const Loc & location);
		virtual void notify_pass();
		virtual void notify_undo();
		virtual void notify_terri(const Loc & location);
		virtual void notify_reset();
		virtual void notify_done();
	};
}
#endif // PLAYER_HH
