/* ccgo: player.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "player.hh"

using namespace go;

void Player::ask_terri(Terri * t)
{
	if (arena) arena->ask_terri(t);
}

Player::Player()
{
	arena = 0;
	playing = false;
	scoring = false;
}

Player::~Player()
{
	// std::cerr << "deleting Player" << std::endl;
	if (arena) {
		if (arena->check_player(go::TURN_WHITE, this)) arena->set_player(go::TURN_WHITE, 0);
		if (arena->check_player(go::TURN_BLACK, this)) arena->set_player(go::TURN_BLACK, 0);
	}
	// std::cerr << "Player deleted" << std::endl;
	arena = 0;
}

void Player::set_arena(Arena * a)
{
	arena = a;
}

void Player::enable_player()
{
	playing = true;
}

void Player::disable_player()
{
	playing = false;
	scoring = false;
}

void Player::enter_scoring()
{
	scoring = true;
}

void Player::done_scoring()
{
	scoring = false;
}

void Player::notify_setup(const Board & board)
{
}

void Player::notify_handicap(unsigned n)
{
}

void Player::notify_put(const Loc &)
{
}

void Player::notify_pass()
{
}

void Player::notify_undo()
{
}

void Player::notify_terri(const Loc &)
{
}

void Player::notify_reset()
{
}

void Player::notify_done()
{
}
