/* ccgo: play_walk.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef PLAY_WALK_HH
#define PLAY_WALK_HH
#include "view_walk.hh"
#include "play_game.hh"
namespace go
{
	class PlayWalk :
		virtual public ViewWalk,
		virtual public PlayGame
	{
		bool player_enabled;
		void end_my_score();
		bool is_score;
		const Walk * play_node; // the node where playing is enabled
	public:
		PlayWalk(Node *);
		virtual ~PlayWalk();
		void set_play_node(const Walk *);
		void enable_player();
		void disable_player();
		void enter_scoring();
		void done_scoring();
		void do_player();
		virtual bool up();
		virtual bool down(unsigned = 0);
	};
}
#endif // PLAY_WALK_HH
