/* ccgo: play_walk.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "play_walk.hh"
#include "proper_node.hh"
#include "score_proper.hh"

using namespace go;

void PlayWalk::end_my_score()
{
	do_player();
	clear_proper();
	ProperNode * pn = dynamic_cast<ProperNode *>(get_pos());
	if (pn) set_proper(* pn->get_proper());
}

PlayWalk::PlayWalk(Node * n) :
	Walk(n),
	GameWalk(n),
	ViewWalk(n)
{
	is_score = false;
	play_node = 0;
}

PlayWalk::~PlayWalk()
{
}

void PlayWalk::set_play_node(const Walk * w)
{
	play_node = w;
}

void PlayWalk::enable_player()
{
	PlayGame::enable_player();
	do_player();
}

void PlayWalk::disable_player()
{
	PlayGame::disable_player();
	do_player();
}

void PlayWalk::enter_scoring()
{
	PlayGame::enter_scoring();
	do_player();
}

void PlayWalk::done_scoring()
{
	PlayGame::done_scoring();
	do_player();
}

void PlayWalk::do_player()
{
	// enable player_input only at the end of a tree and only when it's my turn to play
	if (! play_node) return;
	if (playing) {
		if (* this != * play_node || ! arena->check_player(get_turn(), this)) {
			set_player_input(false);
			set_track_mode(PlayGame::TRACK_NONE);
		}
		else {
			set_player_input(true);
			set_track_mode(PlayGame::TRACK_PLAY);
		}
	} else if (scoring) {
		if (* this != * play_node) {
			set_player_input(false);
			set_track_mode(PlayGame::TRACK_NONE);
		} else {
			set_player_input(true);
			set_track_mode(PlayGame::TRACK_SCORE);
			if (arena) {
				unsigned z = get_board_size();
				Terri * t = new Terri[z * z];
				arena->ask_terri(t);
				PlayGame::set_terri(t);
				delete[] t;
			}
		}
	} else {
		set_player_input(false);
		set_track_mode(PlayGame::TRACK_NONE);
		get_score_bt()->set_sensitive(! is_score);
	}
}

bool PlayWalk::up()
{
	bool r = ViewWalk::up();
	ProperNode * pn;
	is_score = (pn = dynamic_cast<ProperNode *>(get_pos())) && dynamic_cast<ScoreProper *>(pn->get_proper());
	return r;
}

bool PlayWalk::down(unsigned n)
{
	bool r = ViewWalk::down(n);
	ProperNode * pn;
	is_score = (pn = dynamic_cast<ProperNode *>(get_pos())) && dynamic_cast<ScoreProper *>(pn->get_proper());
	return r;
}
