/* ccgo: play_game.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef PLAY_GAME_HH
#define PLAY_GAME_HH
#include "proper_game.hh"
#include "player.hh"
#include <sigc++/signal.h>
#include <gtkmm/box.h>
#include <gtkmm/button.h>
#include <gtkmm/adjustment.h>
#include <gtkmm/spinbutton.h>
namespace go
{
	class PlayGame :
		virtual public ProperGame,
		virtual public Player
	{
	public:
		enum Track {
			TRACK_NONE = 0,
			TRACK_PLAY,
			TRACK_SCORE,
			TRACK_MY_SCORE
		};
	private:
		Track track_mode;
		bool setting_track_mode;

		bool player_input;

		Terri * terri;
		unsigned terri_score_w;
		unsigned terri_score_b;

		Loc track_on;
		bool mark_down;
		Loc track_mark;
		void do_track();
		void clear_track();
		void mark_track();

		Gtk::Button pass_button;
		Gtk::Button undo_button;
		Gtk::VBox handi_control;
		Gtk::Adjustment * h_adj;
		Gtk::VBox control_box;
		Gtk::ToggleButton score_bt;
		void on_track_change();
		void pass_clicked();
		void undo_clicked();
		void handi_clicked();
		bool on_button_press_event(GdkEventButton *);
		bool on_button_release_event(GdkEventButton *);
		void show_hide_buttons();
		void update_terri_scoring();
		void score_toggle();
		virtual void end_my_score();
	public:
		PlayGame();
		virtual ~PlayGame();
		virtual void set_board_size(unsigned);
		Gtk::Widget * get_control();
		Gtk::Widget * get_score_bt();
		void set_move_num(unsigned);
		void set_track_mode(Track);
		Track get_track_mode() const;
		void set_player_input(bool);
		void claim_terri(const Loc &);
		void terri_mark(const std::vector<Loc> &);
		void terri_clear();
		void set_terri(Terri *);
		void enable_player();
		void disable_player();
		void enter_scoring();
		void done_scoring();
	};
}
#endif // PLAY_GAME_HH
