/* ccgo: part_win.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "part_win.hh"
#include "settings.hh"
#include <gtkmm/stock.h>
#include <fstream>

using namespace go;

void PartWin::on_hide()
{
	delete this;
}

void PartWin::init()
{
	Gtk::VPaned * vp = Gtk::manage(new Gtk::VPaned);
	add(* vp);

	Gtk::VBox * vb0 = Gtk::manage(new Gtk::VBox);
	vp->pack1(* vb0);
	Gtk::HBox * hb = Gtk::manage(new Gtk::HBox);
	vb0->pack_start(* hb);
	hb->pack_start(part.get_board_area());

	Gtk::VBox * vb = Gtk::manage(new Gtk::VBox);
	hb->pack_end(* vb, Gtk::PACK_SHRINK);
	vb->pack_start(part.get_button_area());

	Gtk::Button * bt = Gtk::manage(new Gtk::Button(Gtk::Stock::CLOSE));
	vb->pack_end(* bt, Gtk::PACK_SHRINK);
	bt->signal_clicked().connect(mem_fun(* this, & Widget::hide));

	hb = Gtk::manage(new Gtk::HBox);
	vb0->pack_end(* hb, Gtk::PACK_SHRINK);
	hb->pack_start(part.get_modifi_area(), Gtk::PACK_SHRINK);
	hb->pack_end(part.get_label_area(), Gtk::PACK_SHRINK);

	vp->pack2(part.get_text_area());

	my_width = go::settings.get_int("part-win-width");
	if (my_width <= 0) my_width = 360;
	my_height = go::settings.get_int("part-win-height");
	if (my_height <= 0) my_height = 400;
	resize(my_width, my_height);
	set_default_size(360, 400);
	show_all();
}

void PartWin::on_size_allocate(Gtk::Allocation & a)
{
	Gtk::Widget::on_size_allocate(a);
	if (a.get_width() != my_width || a.get_height() != my_height) {
		my_width = a.get_width();
		my_height = a.get_height();
		go::settings.set_int("part-win-width", my_width);
		go::settings.set_int("part-win-height", my_height);
	}
}

PartWin::PartWin(unsigned s, double k, unsigned h, Player * w, Player * b) :
	part(s, k, h)
{
	init();
	part.set_players(w, b);
	w_player = w;
	b_player = b;
}

PartWin::PartWin(const Part & p) :
	part(p)
{
	init();
	part.set_players(0, 0);
	w_player = 0;
	b_player = 0;
}

PartWin::~PartWin()
{
	if (w_player) delete w_player;
	if (b_player) delete b_player;
}
