/* ccgo: part.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef PART_HH
#define PART_HH
#include "proper_node.hh"
#include "play_walk.hh"
#include "player.hh"
#include "time.hh"
#include <gtkmm/label.h>
#include <gtkmm/button.h>
#include <gtkmm/aspectframe.h>
#include <gtkmm/adjustment.h>
#include <gtkmm/textview.h>
#include <gtkmm/paned.h>
#include <gtkmm/box.h>
#include <gtkmm/stock.h>
#include <gtkmm/scrolledwindow.h>

namespace go {
	class Part :
		// public sigc::Object,
		public Arena
	{
		ProperNode * root;
		PlayWalk walk;
		GameWalk tail;
		Gtk::Adjustment * p_adj;
		Gtk::Label n_move;
		void change_position();
		void find_range();
		Gtk::ToggleButton score_bt;
		// void scoring_toggle();
		Gtk::VBox * button_area;
		Terri * terri;
		Time time;
		bool no_play;
		Gtk::ScrolledWindow text_sw;
		bool hold_action;
		void duplicate();
		void init();
	protected:
	public:
		Part(unsigned board_size, double komi, unsigned handicap);
		Part(const Part &);
		~Part();
		virtual void forward();
		virtual void backward();
		virtual const Game * get_game() const;
		virtual void set_players(Player *, Player *);
		virtual void enter_score();
		virtual void done_score();

		virtual bool action_handicap(unsigned);
		virtual bool action_put(const Loc &);
		virtual bool action_pass();
		virtual bool action_undo();
		virtual bool action_terri(const Loc &);
		virtual bool action_reset();
		virtual bool action_done();

		virtual void ask_terri(Terri *);

		sigc::signal<void, unsigned> held_handicap;
		sigc::signal<void, const Loc &, unsigned> held_put;
		sigc::signal<void, unsigned> held_pass;
		sigc::signal<void> held_undo;
		sigc::signal<void, const Loc &> held_terri;
		sigc::signal<void> held_reset;
		sigc::signal<void> held_done;

		unsigned get_time_counter();

		virtual void post_action();
		//
		void set_komi(double);
		bool add_move(go::Move *);
		bool undo_move();
		bool terri_request(const go::Loc & l);
		bool restore_board();
		void start_time(int, int, int);
		void time_update(int, int, int, int);
		void set_no_play(bool = true);
		void set_hold_action(bool = true);
		void stop_game();
		void add_score(Terri *);
		Gtk::Widget & get_board_area();
		Gtk::Widget & get_button_area();
		Gtk::Widget & get_text_area();
		Gtk::Widget & get_modifi_area();
		Gtk::Widget & get_label_area();
	};
}
#endif // PART_HH
