/* ccgo: node.hh
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef NODE_HH
#define NODE_HH
#include <string>
#include <vector>
#include <iostream>
namespace go {
	class Node
	{
		Node * up_link;
		unsigned order;
		std::vector<Node *> link;
	protected:
		virtual Node * create_copy() const;
	public:
		Node();
		virtual ~Node();
		Node * dup() const;
		unsigned get_order() const;
		unsigned set_next(Node *);
		Node * get_next(unsigned = 0) const;
		Node * get_prev() const;
		unsigned get_link_size() const;
		void replace(Node *);
// 		void delete_tree();
		void delete_branch(unsigned = 0);
	};
}
#endif // NODE_HH
