/* ccgo: node.cc
 * 
 * Copyright (C) 2002,2003 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include "node.hh"

using namespace go;
using namespace std;

Node * Node::create_copy() const
{
	return new Node;
}

Node::Node()
{
	up_link = NULL;
	order = 0;
}

Node::~Node()
{
	for (vector<Node *>::iterator i = link.begin(); i != link.end(); ++ i) delete (* i);
	// link.clear();
}

Node * Node::dup() const
{
	Node * new_node = create_copy();
	for (std::vector<Node *>::const_iterator i = link.begin(); i != link.end(); i ++) new_node->set_next((* i)->dup());
	return new_node;
}

unsigned Node::get_order() const
{
	return order;
}

unsigned Node::get_link_size() const
{
	return link.size();
}

unsigned Node::set_next(Node * n)
{
	unsigned i = link.size();
	link.push_back(n);
	n->up_link = this;
	n->order = i;
	return i;
}

Node * Node::get_next(unsigned i) const
{
	if (i >= link.size()) return NULL;
	else return link[i];
}

Node * Node::get_prev() const
{
	return up_link;
}

void Node::replace(Node * n)
{
	n->up_link = up_link;
	n->link = link;
	if (up_link != NULL) up_link->link[order] = n;
}

// void Node::delete_tree()
// {
// 	for (vector<Node *>::iterator i = link.begin(); i != link.end(); ++ i) {
// 		(* i)->delete_tree();
// 		delete (* i);
// 	}
// 	link.clear();
// }

void Node::delete_branch(unsigned n)
{
	if (n >= link.size()) return;
	vector<Node *>::iterator i = link.begin() + n;
	// (* i)->delete_tree();
	delete (* i);
	link.erase(i);
}
