/* ccgo: go/nctest.cc
 *
 * Copyright (C) 2004 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include <nc.hh>
#include <arg.hh>
#include <debug.hh>
#include <go/sgf.hh>
#include <sstream>
#include <fstream>
#include <iomanip>

using namespace std;

int main(int argc, char * argv[])
{
	arg::Parser p;

	p.add_opt('d', "debug")
		.store(arg::SV(debug_level))
		.help("setting debug level to NUM", "NUM");

	string sgf_file;
	p.add_opt('f', "sgf-file")
		.store(arg::SV(sgf_file))
		.help("open FILE as SGF file", "FILE");
	p.add_opt_help();
	p.add_opt_version(string("ccGo ") + VERSION);

	p.parse(argc, argv);

	go::Game * g = 0;
	if (sgf_file.size()) {
		msg(DBG_INFO) << "loading sgf file: " << sgf_file << '\n';
		fstream f(sgf_file.c_str(), ios::in);
		if (f) {
			g = go::read_sgf(f);
		}
		msg(DBG_DEBUG) << "sgf file loaded\n";
	}
	
	if (! g) for (vector<string>::const_iterator i = p.args().begin(); i != p.args().end(); i ++) {
		const string & s = * i;
		if (s.length() < 4) continue;
		if (s.substr(s.length() - 4) == ".sgf") {
			msg(DBG_INFO) << "loading sgf file: " << string(sgf_file) << "\n";
			fstream f(s.c_str(), ios::in);
			if (f) {
				g = go::read_sgf(f);
			}
			msg(DBG_DEBUG) << "sgf loaded\n";
			break;
		}
	}

	if (! g) {
		g = new go::Game;
	}


	Nc::Editor nw;
	nw.set_node(g);
	nw.loop();
	delete g;
	g = 0;
	return 0;
}

