/* ccgo: nc/test-face.cc
 *
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#include <nc/face.hh>
#include <ui/editor.hh>
#include <sstream>

class App :
	public nc::Nc,
	public ui::Editor
{
	nc::Face face;
	bool working;

	void new_window_size(unsigned w, unsigned h)
	{
		unsigned mw = face.get_max_w();
		unsigned mh = face.get_max_h();
		if (w < mw || h < mh) {
			std::ostringstream s;
			s << "window too small (" << mw << ',' << mh << ')';
			working = false;
			draw_text(0, 0, s.str());
			return;
		}
		working = true;
		face.set_window((w - mw) / 2, (h - mh) / 2, mw, mh);
		Nc::move_cursor_to(0, 0);
	}

	void process_key(int c)
	{
		// bool unknown = false;
		if (! working) {
			if (c == 24) stop(); // control-x
			return;
		}
		switch(c) {
		case nc::KeyUp:
			face.do_up();
			break;
		case nc::KeyLeft:
			face.do_left();
			break;
		case nc::KeyRight:
			face.do_right();
			break;
		case nc::KeyDown:
			face.do_down();
			break;
		case '\r':
			face.do_enter();
			break;
		case 'n':
			if (can_init()) {
				init_create();
				message("new game created!");
			}
			else message("can not create new game now!");
			break;
		case 24: // control-x
			stop();
			// break;
		// default:
			// unknown = true;
		}
		Nc::move_cursor_to(0, 0);
	}

	void draw_message(const std::string & str)
	{
		Nc::move_cursor_to(0, 0);
		draw_text(str);
	}

	void clear_message()
	{
		Nc::move_cursor_to(0, 0);
		clear_to_eol();
	}
public:
	App() :
		working(false)
	{
		face.set_nc(this);
		set_face(& face);
		face.set_active(true);
		init_size(9);
	}
};

int main(int argc, char * argv[])
{
	App app;

	app.run();
}
