/* ccgo: nc/test-entry.cc
 *
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#include <nc/entry.hh>
#include <sstream>

class App :
	public nc::Nc
{
	nc::Entry entry;
	bool working;

	void new_window_size(unsigned x, unsigned y)
	{
		if (x < 16 || y < 11) {
			working = false;
			draw_text(0, 0, "window too small");
			return;
		}
		working = true;
		for (unsigned i = 4; i <= x - 5; i ++) {
			move_cursor_to(i, 4);
			draw_char('#');
			move_cursor_to(i, y - 5);
			draw_char('#');
		}
		for (unsigned i = 5; i < y - 5; i ++) {
			move_cursor_to(4, i);
			draw_char('#');
			move_cursor_to(x - 5, i);
			draw_char('#');
		}
		entry.set_window(5, 5, x - 10, y - 10);
		entry.set_cursor();
	}

	void process_key(int c)
	{
		bool unknown = false;
		if (! working) {
			if (c == 24) stop(); // control-x
			return;
		}
		switch(c) {
		case nc::KeyUp:
			entry.do_up();
			break;
		case nc::KeyLeft:
			entry.do_left();
			break;
		case nc::KeyRight:
			entry.do_right();
			break;
		case nc::KeyDown:
			entry.do_down();
			break;
		case 1: // control-a
		case nc::KeyHome:
			entry.do_home();
			break;
		case 5: // control-e
		case nc::KeyEnd:
			entry.do_end();
			break;
		case '\r':
			entry.do_enter();
			break;
		case 8: // control-h
		case nc::KeyBackspace:
			entry.do_back();
			break;
		case nc::KeyDC:
		case 4: // control-d
			entry.do_delete();
			break;
		case nc::KeyPPage:
			entry.do_page_up();
			break;
		case nc::KeyNPage:
			entry.do_page_down();
			break;
		case 24: // control-x
			stop();
			break;
		case 7: // control-g
			entry.set_guide(! entry.get_guide());
			break;
		default:
			if (c >= 32 && c < 128) entry.do_insert(c);
			else unknown = true;
		}
		if (unknown) {
			std::ostringstream s;
			s << "unknown key: " << c;
			message(s.str());
		}

		entry.set_cursor();
	}

public:
	App() :
		working(false)
	{
		entry.set_nc(this);
		entry.set_text("This is an entry window");
	}
};

int main(int argc, char * argv[])
{
	App app;

	app.run();
}
