/* ccgo: nc/nc.hh
 *
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef NC_NC_HH
#define NC_NC_HH

#include <string>

namespace nc {
	// ncurses keys
	const int KeyDown = 0402;	// down-arrow
	const int KeyUp = 0403;		// up-arrow
	const int KeyLeft = 0404;	// left-arrow
	const int KeyRight = 0405;	// right-arrow
	const int KeyHome = 0406;	// home
        const int KeyBackspace = 0407;	// backspace
	const int KeyDC = 0512;		// delete character
	const int KeyNPage = 0522;	// next-page
	const int KeyPPage = 0523;	// previous-page
	const int KeyBTab = 0541;	// back-tab
	const int KeyEnd = 0550;	// end

	// additional keys
	const int KeyCtrlDown = 0634;	// control-down
	const int KeyCtrlUp = 0635;	// control-up
	const int KeyCtrlLeft = 0636;	// control-left
	const int KeyCtrlRight = 0637;	// control-right
	const int Err = - 1;

	typedef short Color;
	typedef short ColorPair;

	const Color ColorDefault = - 1;
	const Color ColorBlack = 0;
	const Color ColorRed = 1;
	const Color ColorGreen = 2;
	const Color ColorYellow = 3;
	const Color ColorBlue = 4;
	const Color ColorMagenta = 5;
	const Color ColorCyan = 6;
	const Color ColorWhite = 7;

	class Nc
	{
		bool running;
		int bkgd_char;
	protected:
		virtual void new_window_size(unsigned w, unsigned h); // configure
		virtual void prompt();
		virtual void process_key(int c);
		virtual void draw_message(const std::string & str);
		virtual void clear_message();
		void stop();
	public:
		Nc();
		virtual ~Nc();
		void run();

		// drawing functions
		void move_cursor_to(unsigned x, unsigned y);
		void draw_char(char c);
		void draw_char(unsigned x, unsigned y, char c);
		void draw_text(std::string str);
		void draw_text(unsigned x, unsigned y, std::string str);
		void clear_to_eol();

		// attributes
		void set_reverse();
		void unset_reverse();
		void set_bold();
		void unset_bold();

		// color
		ColorPair color_pairs();
		void make_color(ColorPair pair, Color fg, Color bg);
		void set_color(ColorPair pair);
		void unset_color(ColorPair pair);

		// input
		int get_key();
		std::string read_line();

		// messages
		void message(std::string str);

		// reconfiguration
		void reconfigure();
	};
}
#endif // NC_NC_HH
