/* ccgo: nc/misc.cc
 *
 * Copyright (C) 2006 Chun-Chung Chen <cjj@u.washington.edu>
 * 
 * This file is part of ccGo.
 * 
 * ccGo is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */
#include <nc/misc.hh>
#include <debug.hh>
#include <sstream>

using namespace nc;
using namespace std;

string nc::xy_to_str(unsigned x, unsigned y)
{
	char c = 'a' + x;
	if (c >= 'i') c ++;
	ostringstream s;
	s << c << y + 1;
	return s.str();
}

string nc::mark_to_str(go::Mark mk)
{
	static const char * s[] = {
		"",
		"Circle",
		"Triangle",
		"Square",
		"Cross",
		"Select",
		"WhiteTerritory",
		"BlackTerritory"
	};
	assert(mk < int(sizeof(s)));
	return s[mk];
}
